/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.example;

import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.interceptor.RequestInterceptor;

public class CustomJWTClaimsInterceptor
implements RequestInterceptor {
    private static final String JWT_HEADER = "X-JWT-Assertion";
    private static final String AUTH_TYPE_JWT = "JWT";

    @Override
    public boolean interceptRequest(Request request, Response response) throws Exception {
        SignedJWT signedJWT;
        ReadOnlyJWTClaimsSet readOnlyJWTClaimsSet;
        String jwtHeader;
        HttpHeaders headers = request.getHeaders();
        if (headers != null && (jwtHeader = headers.getHeaderString(JWT_HEADER)) != null && (readOnlyJWTClaimsSet = (signedJWT = SignedJWT.parse(jwtHeader)).getJWTClaimsSet()) != null) {
            return true;
        }
        response.setHeader("WWW-Authenticate", AUTH_TYPE_JWT);
        response.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
        return false;
    }
}

