/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.DefaultSessionManager;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.MicroservicesRegistry;
import org.wso2.msf4j.SessionManager;
import org.wso2.msf4j.SwaggerService;
import org.wso2.msf4j.interceptor.RequestInterceptor;
import org.wso2.msf4j.interceptor.ResponseInterceptor;
import org.wso2.msf4j.internal.ClassComparator;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.MicroservicesLCException;
import org.wso2.msf4j.internal.router.MicroserviceMetadata;

public class MicroservicesRegistryImpl
implements MicroservicesRegistry {
    private static final Logger log = LoggerFactory.getLogger(MicroservicesRegistryImpl.class);
    private final Map<String, Object> services = new HashMap<String, Object>();
    private List<RequestInterceptor> globalRequestInterceptorList = new ArrayList<RequestInterceptor>();
    private List<ResponseInterceptor> globalResponseInterceptorList = new ArrayList<ResponseInterceptor>();
    private volatile MicroserviceMetadata metadata = new MicroserviceMetadata(Collections.emptyMap());
    private Map<Class, ExceptionMapper> exceptionMappers = new TreeMap<Class, ExceptionMapper>(new ClassComparator());
    private SessionManager sessionManager = new DefaultSessionManager();

    public MicroservicesRegistryImpl() {
        ServiceLoader<SwaggerService> swaggerServices;
        Iterator<SwaggerService> iterator;
        if (DataHolder.getInstance().getBundleContext() == null && (iterator = (swaggerServices = ServiceLoader.load(SwaggerService.class)).iterator()).hasNext()) {
            SwaggerService swaggerService = iterator.next();
            swaggerService.init(this);
            this.services.put("/swagger", swaggerService);
        }
    }

    @Override
    public void addService(Object ... service) {
        for (Object svc2 : service) {
            this.services.put(svc2.getClass().getAnnotation(Path.class).value(), svc2);
        }
        this.updateMetadata();
        if (log.isDebugEnabled()) {
            Arrays.stream(service).forEach(svc -> log.debug("Added microservice: {}.", svc));
        }
    }

    @Override
    public void addService(String basePath, Object service) {
        this.services.put(basePath, service);
        this.metadata.addMicroserviceMetadata(service, basePath);
        log.debug("Added microservice: {}.", service);
    }

    @Override
    public Optional<Map.Entry<String, Object>> getServiceWithBasePath(String path) {
        return this.services.entrySet().stream().filter(svc -> ((String)svc.getKey()).equals(path)).findAny();
    }

    @Override
    public void removeService(Object service) {
        if (service == null) {
            log.error("Service cannot be null.");
            return;
        }
        Path path = service.getClass().getAnnotation(Path.class);
        if (path == null) {
            log.warn("Service removal failed. Microservice class '" + service.getClass().getName() + "' doesn't contain a root Path.");
            return;
        }
        this.services.remove(path.value());
        this.updateMetadata();
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        if (sessionManager == null) {
            throw new IllegalArgumentException("SessionManager cannot be null");
        }
        this.sessionManager = sessionManager;
    }

    @Override
    public void addInterceptor(Interceptor ... interceptor) {
        Collections.addAll(this.globalRequestInterceptorList, interceptor);
        Collections.addAll(this.globalResponseInterceptorList, interceptor);
    }

    @Override
    public void removeInterceptor(Interceptor interceptor) {
        this.globalRequestInterceptorList.remove(interceptor);
        this.globalResponseInterceptorList.remove(interceptor);
    }

    public MicroserviceMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Set<Object> getHttpServices() {
        return Collections.unmodifiableSet(this.services.values().stream().collect(Collectors.toSet()));
    }

    @Override
    public void addGlobalRequestInterceptor(RequestInterceptor ... requestInterceptor) {
        Collections.addAll(this.globalRequestInterceptorList, requestInterceptor);
    }

    @Override
    public void addGlobalResponseInterceptor(ResponseInterceptor ... responseInterceptor) {
        Collections.addAll(this.globalResponseInterceptorList, responseInterceptor);
    }

    @Override
    public void removeGlobalRequestInterceptor(RequestInterceptor requestInterceptor) {
        this.globalRequestInterceptorList.remove(requestInterceptor);
    }

    @Override
    public void removeGlobalResponseInterceptor(ResponseInterceptor responseInterceptor) {
        this.globalResponseInterceptorList.remove(responseInterceptor);
    }

    public List<RequestInterceptor> getGlobalRequestInterceptorList() {
        return this.globalRequestInterceptorList;
    }

    public List<ResponseInterceptor> getGlobalResponseInterceptorList() {
        return this.globalResponseInterceptorList;
    }

    @Override
    public void addExceptionMapper(ExceptionMapper ... mapper) {
        Arrays.stream(mapper).forEach(em -> Arrays.stream(em.getClass().getMethods()).filter(method -> "toResponse".equals(method.getName()) && method.getParameterCount() == 1 && !Throwable.class.getName().equals(method.getParameterTypes()[0].getTypeName())).findAny().ifPresent(method -> {
            try {
                this.exceptionMappers.put(Class.forName(method.getParameterTypes()[0].getTypeName(), false, em.getClass().getClassLoader()), (ExceptionMapper)em);
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class", e);
            }
        }));
    }

    Optional<ExceptionMapper> getExceptionMapper(Throwable throwable) {
        return this.exceptionMappers.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(throwable.getClass())).findFirst().flatMap(entry -> Optional.ofNullable(entry.getValue()));
    }

    @Override
    public void removeExceptionMapper(ExceptionMapper em) {
        Arrays.stream(em.getClass().getMethods()).filter(method -> method.getName().equals("toResponse") && method.getParameterCount() == 1).findAny().ifPresent(method -> {
            try {
                this.exceptionMappers.remove(Class.forName(method.getGenericParameterTypes()[0].getTypeName(), false, em.getClass().getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class", e);
            }
        });
    }

    public int getServiceCount() {
        return this.services.size();
    }

    private void updateMetadata() {
        this.metadata = new MicroserviceMetadata(Collections.unmodifiableMap(this.services));
    }

    @Override
    public void initServices() {
        this.invokeLifecycleMethods(PostConstruct.class);
    }

    @Override
    public void initService(Object httpService) {
        this.invokeLifecycleMethod(httpService, PostConstruct.class);
    }

    @Override
    public void preDestroyServices() {
        this.invokeLifecycleMethods(PreDestroy.class);
    }

    @Override
    public void preDestroyService(Object httpService) {
        this.invokeLifecycleMethod(httpService, PreDestroy.class);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    private void invokeLifecycleMethods(Class lcAnnotation) {
        this.services.values().stream().forEach(httpService -> this.invokeLifecycleMethod(httpService, lcAnnotation));
    }

    private void invokeLifecycleMethod(Object httpService, Class lcAnnotation) {
        Optional<Method> lcMethod = Optional.ofNullable(this.getLifecycleMethod(httpService, lcAnnotation));
        if (lcMethod.isPresent()) {
            try {
                lcMethod.get().invoke(httpService, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new MicroservicesLCException("Exception occurs calling lifecycle method", e);
            }
        }
    }

    private Method getLifecycleMethod(Object httpService, Class lcAnnotation) {
        return Arrays.stream(httpService.getClass().getDeclaredMethods()).filter(m -> this.isValidLifecycleMethod(Optional.of(m), lcAnnotation)).findFirst().orElse(null);
    }

    private boolean isValidLifecycleMethod(Optional<Method> method, Class lcAnnotation) {
        return method.filter(m -> Modifier.isPublic(m.getModifiers()) && m.getAnnotation(lcAnnotation) != null).isPresent();
    }
}

