/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common.http2;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ExceptionHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(Http2ExceptionHandler.class);
    private Http2ConnectionHandler http2ConnectionHandler;

    public Http2ExceptionHandler(Http2ConnectionHandler http2ConnectionHandler) {
        this.http2ConnectionHandler = http2ConnectionHandler;
    }

    public Http2ExceptionHandler() {
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.http2ConnectionHandler != null && Http2CodecUtil.getEmbeddedHttp2Exception(cause) != null) {
            this.http2ConnectionHandler.onError(ctx, false, cause);
        } else {
            ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
        if (!cause.toString().contains("ssl") && !cause.toString().contains("security")) {
            LOG.error("Exception occurred in HTTP/2 inbound channel", cause);
        }
    }
}

