/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.exceptions.ClientConnectorException;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.SenderReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.states.ReceivingEntityBody;
import org.wso2.transport.http.netty.contractimpl.sender.states.ReceivingHeaders;
import org.wso2.transport.http.netty.contractimpl.sender.states.SenderState;
import org.wso2.transport.http.netty.contractimpl.sender.states.SendingEntityBody;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class Sending100Continue
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(Sending100Continue.class);
    private final SenderReqRespStateManager senderReqRespStateManager;
    private final HttpResponseFuture httpInboundResponseFuture;
    private TargetHandler targetHandler;
    private HttpCarbonMessage httpOutboundRequest;
    private List<HttpContent> contentList = new ArrayList<HttpContent>();

    Sending100Continue(SenderReqRespStateManager senderReqRespStateManager, HttpResponseFuture httpInboundResponseFuture) {
        this.senderReqRespStateManager = senderReqRespStateManager;
        this.httpInboundResponseFuture = httpInboundResponseFuture;
        this.configIdleTimeoutTrigger(senderReqRespStateManager.socketTimeout / 5);
    }

    private void configIdleTimeoutTrigger(int socketIdleTimeout) {
        ChannelPipeline pipeline = this.senderReqRespStateManager.nettyTargetChannel.pipeline();
        IdleStateHandler idleStateHandler = new IdleStateHandler(0L, 0L, socketIdleTimeout, TimeUnit.MILLISECONDS);
        Util.safelyRemoveHandlers(pipeline, "idleStateHandler");
        if (pipeline.get("targetHandler") == null) {
            pipeline.addLast("idleStateHandler", (ChannelHandler)idleStateHandler);
        } else {
            pipeline.addBefore("targetHandler", "idleStateHandler", idleStateHandler);
        }
    }

    @Override
    public void writeOutboundRequestHeaders(HttpCarbonMessage httpOutboundRequest) {
        this.httpOutboundRequest = httpOutboundRequest;
    }

    @Override
    public void writeOutboundRequestEntity(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        this.contentList.add(httpContent);
    }

    @Override
    public void readInboundResponseHeaders(TargetHandler targetHandler, HttpResponse httpInboundResponse) {
        this.targetHandler = targetHandler;
        this.configIdleTimeoutTrigger(this.senderReqRespStateManager.socketTimeout);
        if (httpInboundResponse.status().code() == HttpResponseStatus.CONTINUE.code()) {
            this.senderReqRespStateManager.state = new SendingEntityBody(this.senderReqRespStateManager, this.httpInboundResponseFuture);
            for (HttpContent cachedHttpContent : this.contentList) {
                this.senderReqRespStateManager.writeOutboundRequestEntity(this.httpOutboundRequest, cachedHttpContent);
            }
        } else if (targetHandler.getHttpResponseFuture() != null) {
            for (HttpContent cachedHttpContent : this.contentList) {
                cachedHttpContent.release();
            }
            this.senderReqRespStateManager.state = new ReceivingHeaders(this.senderReqRespStateManager);
            this.senderReqRespStateManager.readInboundResponseHeaders(targetHandler, httpInboundResponse);
        } else {
            LOG.error("Cannot notify the response to client as there is no associated responseFuture");
        }
    }

    @Override
    public void readInboundResponseEntityBody(ChannelHandlerContext ctx, HttpContent httpContent, HttpCarbonMessage inboundResponseMsg) throws Exception {
        this.senderReqRespStateManager.state = new ReceivingEntityBody(this.senderReqRespStateManager, this.targetHandler);
        this.senderReqRespStateManager.readInboundResponseEntityBody(ctx, httpContent, inboundResponseMsg);
    }

    @Override
    public void handleAbruptChannelClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture) {
        for (HttpContent cachedHttpContent : this.contentList) {
            cachedHttpContent.release();
        }
        httpResponseFuture.notifyHttpListener(new ClientConnectorException(this.senderReqRespStateManager.nettyTargetChannel.id().asShortText(), "Remote host closed the connection before reading 100 continue response"));
        LOG.error("Error in HTTP client: {}", (Object)"Remote host closed the connection before reading 100 continue response");
    }

    @Override
    public void handleIdleTimeoutConnectionClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture, String channelID) {
        this.configIdleTimeoutTrigger(this.senderReqRespStateManager.socketTimeout);
        this.senderReqRespStateManager.state = new SendingEntityBody(this.senderReqRespStateManager, this.httpInboundResponseFuture);
        for (HttpContent cachedHttpContent : this.contentList) {
            this.senderReqRespStateManager.writeOutboundRequestEntity(this.httpOutboundRequest, cachedHttpContent);
        }
    }
}

