/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.MRU;
import org.apache.directory.server.i18n.I18n;

public class SoftCache
implements CachePolicy {
    private static final int INITIAL_CAPACITY = 128;
    private static final float DEFAULT_LOAD_FACTOR = 1.5f;
    private final ReferenceQueue _clearQueue = new ReferenceQueue();
    private final CachePolicy _internal;
    private final Map _cacheMap;

    public SoftCache() {
        this(new MRU(128));
    }

    public SoftCache(CachePolicy internal) throws NullPointerException {
        this(1.5f, internal);
    }

    public SoftCache(float loadFactor, CachePolicy internal) throws IllegalArgumentException, NullPointerException {
        if (internal == null) {
            throw new NullPointerException(I18n.err(I18n.ERR_531, new Object[0]));
        }
        this._internal = internal;
        this._cacheMap = new HashMap(128, loadFactor);
    }

    public void put(Object key, Object value) throws CacheEvictionException {
        if (key == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_532, new Object[0]));
        }
        if (value == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_533, new Object[0]));
        }
        this._internal.put(key, value);
        this.removeClearedEntries();
        this._cacheMap.put(key, new Entry(key, value, this._clearQueue));
    }

    public Object get(Object key) {
        Object value = this._internal.get(key);
        if (value != null) {
            return value;
        }
        this.removeClearedEntries();
        Entry entry = (Entry)this._cacheMap.get(key);
        if (entry == null) {
            return null;
        }
        value = entry.getValue();
        if (value == null) {
            return null;
        }
        try {
            this._internal.put(key, value);
        }
        catch (CacheEvictionException e) {
            this._cacheMap.remove(key);
            return null;
        }
        return value;
    }

    public void remove(Object key) {
        this._cacheMap.remove(key);
        this._internal.remove(key);
    }

    public void removeAll() {
        this._cacheMap.clear();
        this._internal.removeAll();
    }

    public Enumeration elements() {
        return this._internal.elements();
    }

    public void addListener(CachePolicyListener listener) throws IllegalArgumentException {
        this._internal.addListener(listener);
    }

    public void removeListener(CachePolicyListener listener) {
        this._internal.removeListener(listener);
    }

    private final void removeClearedEntries() {
        Reference r = this._clearQueue.poll();
        while (r != null) {
            Object key = ((Entry)r).getKey();
            this._cacheMap.remove(key);
            r = this._clearQueue.poll();
        }
    }

    private static class Entry
    extends SoftReference {
        private final Object _key;

        public Entry(Object key, Object value, ReferenceQueue queue) {
            super(value, queue);
            this._key = key;
        }

        final Object getKey() {
            return this._key;
        }

        final Object getValue() {
            return this.get();
        }
    }
}

