/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.directory.server.kerberos.shared.io.encoder.Encoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionKeyEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.HostAddressesEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.LastRequestEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.KdcReply;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public abstract class EncKdcRepPartEncoder
implements Encoder {
    private int applicationCode;

    protected EncKdcRepPartEncoder(int applicationCode) {
        this.applicationCode = applicationCode;
    }

    public byte[] encode(Encodable app) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        DERSequence initialSequence = this.encodeInitialSequence((KdcReply)app);
        aos.writeObject(DERApplicationSpecific.valueOf(this.applicationCode, initialSequence));
        return baos.toByteArray();
    }

    protected DERSequence encodeInitialSequence(KdcReply reply) {
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(0, EncryptionKeyEncoder.encodeSequence(reply.getKey())));
        sequence.add(new DERTaggedObject(1, LastRequestEncoder.encode(reply.getLastRequest())));
        sequence.add(new DERTaggedObject(2, DERInteger.valueOf(reply.getNonce())));
        if (reply.getKeyExpiration() != null) {
            sequence.add(new DERTaggedObject(3, KerberosTimeEncoder.encode(reply.getKeyExpiration())));
        }
        sequence.add(new DERTaggedObject(4, new DERBitString(reply.getFlags().getBytes())));
        sequence.add(new DERTaggedObject(5, KerberosTimeEncoder.encode(reply.getAuthTime())));
        if (reply.getStartTime() != null) {
            sequence.add(new DERTaggedObject(6, KerberosTimeEncoder.encode(reply.getStartTime())));
        }
        sequence.add(new DERTaggedObject(7, KerberosTimeEncoder.encode(reply.getEndTime())));
        if (reply.getRenewTill() != null) {
            sequence.add(new DERTaggedObject(8, KerberosTimeEncoder.encode(reply.getRenewTill())));
        }
        sequence.add(new DERTaggedObject(9, DERGeneralString.valueOf(reply.getServerRealm().toString())));
        sequence.add(new DERTaggedObject(10, PrincipalNameEncoder.encode(reply.getServerPrincipal())));
        if (reply.getClientAddresses() != null) {
            sequence.add(new DERTaggedObject(11, HostAddressesEncoder.encodeSequence(reply.getClientAddresses())));
        }
        return sequence;
    }
}

