/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.GrantAndDenial;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ACIItem
implements Serializable {
    private String identificationTag;
    private int precedence = 0;
    private AuthenticationLevel authenticationLevel;

    protected ACIItem(String identificationTag, int precedence, AuthenticationLevel authenticationLevel) {
        if (identificationTag == null) {
            throw new NullPointerException(I18n.err("ERR_04001", new Object[0]));
        }
        if (precedence < 0 || precedence > 255) {
            throw new IllegalArgumentException(I18n.err("ERR_04002", precedence));
        }
        if (authenticationLevel == null) {
            throw new NullPointerException(I18n.err("ERR_04003", new Object[0]));
        }
        this.identificationTag = identificationTag;
        this.precedence = precedence;
        this.authenticationLevel = authenticationLevel;
    }

    public String getIdentificationTag() {
        return this.identificationTag;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public abstract Collection<ACITuple> toTuples();

    protected static Set<MicroOperation> toMicroOperations(Set<GrantAndDenial> grantsAndDenials) {
        HashSet<MicroOperation> microOps = new HashSet<MicroOperation>();
        for (GrantAndDenial grantAndDenial : grantsAndDenials) {
            microOps.add(grantAndDenial.getMicroOperation());
        }
        return microOps;
    }
}

