/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.config.model;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.config.model.ScheduledReporterConfig;
import org.wso2.carbon.metrics.core.reporter.ReporterBuildException;
import org.wso2.carbon.metrics.core.reporter.ReporterBuilder;
import org.wso2.carbon.metrics.core.reporter.impl.Slf4jReporter;

public class Slf4jReporterConfig
extends ScheduledReporterConfig
implements ReporterBuilder<Slf4jReporter> {
    private static final Logger logger = LoggerFactory.getLogger(Slf4jReporterConfig.class);
    private String loggerName = "metrics";
    private String markerName;

    public Slf4jReporterConfig() {
        super("SLF4J");
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getMarkerName() {
        return this.markerName;
    }

    public void setMarkerName(String markerName) {
        this.markerName = markerName;
    }

    @Override
    public Optional<Slf4jReporter> build(MetricRegistry metricRegistry, MetricFilter metricFilter) throws ReporterBuildException {
        if (!this.isEnabled()) {
            return Optional.empty();
        }
        if (this.loggerName == null || this.loggerName.trim().isEmpty()) {
            throw new ReporterBuildException("Logger Name is not specified for SLF4J Reporting.");
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Creating SLF4J reporter for Metrics with logger name '%s' and %d seconds polling period", this.loggerName, this.getPollingPeriod()));
        }
        return Optional.of(new Slf4jReporter(this.getName(), metricRegistry, this.getFilter(metricFilter), this.loggerName, this.markerName, this.getPollingPeriod()));
    }
}

