/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.util.intern.duplex;

import java.util.EnumSet;
import org.w3c.dom.Node;
import org.xmlbeam.util.intern.duplex.ExpressionType;
import org.xmlbeam.util.intern.duplex.INodeEvaluationVisitor;
import org.xmlbeam.util.intern.duplex.SimpleNode;
import org.xmlbeam.util.intern.duplex.XBXPathExprNotAllowedForWriting;

class ExpressionTypeEvaluationVisitor
implements INodeEvaluationVisitor<ExpressionType> {
    ExpressionTypeEvaluationVisitor() {
    }

    @Override
    public ExpressionType visit(SimpleNode node, Node data) {
        switch (node.getID()) {
            case 0: 
            case 1: 
            case 8: 
            case 35: 
            case 55: {
                return node.firstChildAccept(this, data);
            }
            case 32: {
                return node.lastChildAccept(this, data);
            }
            case 37: {
                return "@".equals(node.getValue()) ? ExpressionType.ATTRIBUTE : ExpressionType.ELEMENT;
            }
            case 89: {
                return "root".equals(node.getValue()) ? ExpressionType.ELEMENT : ExpressionType.VALUE;
            }
            case 23: {
                final EnumSet<ExpressionType> types = EnumSet.noneOf(ExpressionType.class);
                node.eachDirectChild(new INodeEvaluationVisitor.VisitorClosure(){

                    @Override
                    public void apply(SimpleNode node, Node data) {
                        types.add(ExpressionTypeEvaluationVisitor.this.visit(node, data));
                    }
                }, data);
                if (types.isEmpty()) {
                    throw new IllegalStateException("Can not determine type of union expression. This may be a bug. Please report!");
                }
                if (types.size() == 1) {
                    return (ExpressionType)((Object)types.iterator().next());
                }
                if (types.contains((Object)ExpressionType.VALUE)) {
                    return ExpressionType.VALUE;
                }
                return ExpressionType.NODE;
            }
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return ExpressionType.VALUE;
            }
            case 36: {
                if ("self".equals(node.getValue())) {
                    return ExpressionType.NODE;
                }
                return "attribute".equals(node.getValue()) ? ExpressionType.ATTRIBUTE : ExpressionType.ELEMENT;
            }
            case 38: 
            case 39: {
                return ExpressionType.ELEMENT;
            }
            case 54: {
                return ExpressionType.NODE;
            }
            case 33: {
                throw new XBXPathExprNotAllowedForWriting(node, "Expression does not select anything.");
            }
        }
        throw new IllegalStateException("Unknown Node " + node);
    }
}

