/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.appsync.CfnApi;
import software.amazon.awscdk.services.appsync.CfnApiProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appsync.CfnApi")
public class CfnApi
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApi.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApi(@NotNull Construct scope, @NotNull String id, @NotNull CfnApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrApiArn() {
        return (String)Kernel.get((Object)this, (String)"attrApiArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrApiId() {
        return (String)Kernel.get((Object)this, (String)"attrApiId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrDns() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrDns", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrDnsHttp() {
        return (String)Kernel.get((Object)this, (String)"attrDnsHttp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDnsRealtime() {
        return (String)Kernel.get((Object)this, (String)"attrDnsRealtime", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getEventConfig() {
        return Kernel.get((Object)this, (String)"eventConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEventConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"eventConfig", (Object)value);
    }

    public void setEventConfig(@Nullable EventConfigProperty value) {
        Kernel.set((Object)this, (String)"eventConfig", (Object)value);
    }

    @Nullable
    public String getOwnerContact() {
        return (String)Kernel.get((Object)this, (String)"ownerContact", (NativeType)NativeType.forClass(String.class));
    }

    public void setOwnerContact(@Nullable String value) {
        Kernel.set((Object)this, (String)"ownerContact", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApi> {
        private final Construct scope;
        private final String id;
        private final CfnApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApiProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder eventConfig(IResolvable eventConfig) {
            this.props.eventConfig(eventConfig);
            return this;
        }

        public Builder eventConfig(EventConfigProperty eventConfig) {
            this.props.eventConfig(eventConfig);
            return this;
        }

        public Builder ownerContact(String ownerContact) {
            this.props.ownerContact(ownerContact);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnApi build() {
            return new CfnApi(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appsync.CfnApi.OpenIDConnectConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OpenIDConnectConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getIssuer();

        @Nullable
        default public Number getAuthTtl() {
            return null;
        }

        @Nullable
        default public String getClientId() {
            return null;
        }

        @Nullable
        default public Number getIatTtl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OpenIDConnectConfigProperty> {
            String issuer;
            Number authTtl;
            String clientId;
            Number iatTtl;

            public Builder issuer(String issuer) {
                this.issuer = issuer;
                return this;
            }

            public Builder authTtl(Number authTtl) {
                this.authTtl = authTtl;
                return this;
            }

            public Builder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public Builder iatTtl(Number iatTtl) {
                this.iatTtl = iatTtl;
                return this;
            }

            public OpenIDConnectConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appsync.CfnApi.LambdaAuthorizerConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaAuthorizerConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAuthorizerUri();

        @Nullable
        default public Number getAuthorizerResultTtlInSeconds() {
            return null;
        }

        @Nullable
        default public String getIdentityValidationExpression() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaAuthorizerConfigProperty> {
            String authorizerUri;
            Number authorizerResultTtlInSeconds;
            String identityValidationExpression;

            public Builder authorizerUri(String authorizerUri) {
                this.authorizerUri = authorizerUri;
                return this;
            }

            public Builder authorizerResultTtlInSeconds(Number authorizerResultTtlInSeconds) {
                this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
                return this;
            }

            public Builder identityValidationExpression(String identityValidationExpression) {
                this.identityValidationExpression = identityValidationExpression;
                return this;
            }

            public LambdaAuthorizerConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appsync.CfnApi.EventLogConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventLogConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getCloudWatchLogsRoleArn();

        @NotNull
        public String getLogLevel();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventLogConfigProperty> {
            String cloudWatchLogsRoleArn;
            String logLevel;

            public Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
                this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
                return this;
            }

            public Builder logLevel(String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            public EventLogConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appsync.CfnApi.EventConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getAuthProviders();

        @NotNull
        public Object getConnectionAuthModes();

        @NotNull
        public Object getDefaultPublishAuthModes();

        @NotNull
        public Object getDefaultSubscribeAuthModes();

        @Nullable
        default public Object getLogConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventConfigProperty> {
            Object authProviders;
            Object connectionAuthModes;
            Object defaultPublishAuthModes;
            Object defaultSubscribeAuthModes;
            Object logConfig;

            public Builder authProviders(IResolvable authProviders) {
                this.authProviders = authProviders;
                return this;
            }

            public Builder authProviders(List<? extends Object> authProviders) {
                this.authProviders = authProviders;
                return this;
            }

            public Builder connectionAuthModes(IResolvable connectionAuthModes) {
                this.connectionAuthModes = connectionAuthModes;
                return this;
            }

            public Builder connectionAuthModes(List<? extends Object> connectionAuthModes) {
                this.connectionAuthModes = connectionAuthModes;
                return this;
            }

            public Builder defaultPublishAuthModes(IResolvable defaultPublishAuthModes) {
                this.defaultPublishAuthModes = defaultPublishAuthModes;
                return this;
            }

            public Builder defaultPublishAuthModes(List<? extends Object> defaultPublishAuthModes) {
                this.defaultPublishAuthModes = defaultPublishAuthModes;
                return this;
            }

            public Builder defaultSubscribeAuthModes(IResolvable defaultSubscribeAuthModes) {
                this.defaultSubscribeAuthModes = defaultSubscribeAuthModes;
                return this;
            }

            public Builder defaultSubscribeAuthModes(List<? extends Object> defaultSubscribeAuthModes) {
                this.defaultSubscribeAuthModes = defaultSubscribeAuthModes;
                return this;
            }

            public Builder logConfig(IResolvable logConfig) {
                this.logConfig = logConfig;
                return this;
            }

            public Builder logConfig(EventLogConfigProperty logConfig) {
                this.logConfig = logConfig;
                return this;
            }

            public EventConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appsync.CfnApi.DnsMapProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DnsMapProperty
    extends JsiiSerializable {
        @Nullable
        default public String getHttp() {
            return null;
        }

        @Nullable
        default public String getRealtime() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DnsMapProperty> {
            String http;
            String realtime;

            public Builder http(String http) {
                this.http = http;
                return this;
            }

            public Builder realtime(String realtime) {
                this.realtime = realtime;
                return this;
            }

            public DnsMapProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appsync.CfnApi.CognitoConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CognitoConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAwsRegion();

        @NotNull
        public String getUserPoolId();

        @Nullable
        default public String getAppIdClientRegex() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CognitoConfigProperty> {
            String awsRegion;
            String userPoolId;
            String appIdClientRegex;

            public Builder awsRegion(String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            public Builder userPoolId(String userPoolId) {
                this.userPoolId = userPoolId;
                return this;
            }

            public Builder appIdClientRegex(String appIdClientRegex) {
                this.appIdClientRegex = appIdClientRegex;
                return this;
            }

            public CognitoConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appsync.CfnApi.AuthProviderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthProviderProperty
    extends JsiiSerializable {
        @NotNull
        public String getAuthType();

        @Nullable
        default public Object getCognitoConfig() {
            return null;
        }

        @Nullable
        default public Object getLambdaAuthorizerConfig() {
            return null;
        }

        @Nullable
        default public Object getOpenIdConnectConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthProviderProperty> {
            String authType;
            Object cognitoConfig;
            Object lambdaAuthorizerConfig;
            Object openIdConnectConfig;

            public Builder authType(String authType) {
                this.authType = authType;
                return this;
            }

            public Builder cognitoConfig(IResolvable cognitoConfig) {
                this.cognitoConfig = cognitoConfig;
                return this;
            }

            public Builder cognitoConfig(CognitoConfigProperty cognitoConfig) {
                this.cognitoConfig = cognitoConfig;
                return this;
            }

            public Builder lambdaAuthorizerConfig(IResolvable lambdaAuthorizerConfig) {
                this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
                return this;
            }

            public Builder lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty lambdaAuthorizerConfig) {
                this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
                return this;
            }

            public Builder openIdConnectConfig(IResolvable openIdConnectConfig) {
                this.openIdConnectConfig = openIdConnectConfig;
                return this;
            }

            public Builder openIdConnectConfig(OpenIDConnectConfigProperty openIdConnectConfig) {
                this.openIdConnectConfig = openIdConnectConfig;
                return this;
            }

            public AuthProviderProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appsync.CfnApi.AuthModeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthModeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAuthType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthModeProperty> {
            String authType;

            public Builder authType(String authType) {
                this.authType = authType;
                return this;
            }

            public AuthModeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

