/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.lambda.BucketOptions;
import software.amazon.awscdk.services.lambda.Code;
import software.amazon.awscdk.services.lambda.CodeConfig;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lambda.S3CodeV2")
public class S3CodeV2
extends Code {
    protected S3CodeV2(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3CodeV2(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3CodeV2(@NotNull IBucket bucket, @NotNull String key, @Nullable BucketOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required"), Objects.requireNonNull(key, "key is required"), options});
    }

    public S3CodeV2(@NotNull IBucket bucket, @NotNull String key) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required"), Objects.requireNonNull(key, "key is required")});
    }

    @Override
    @NotNull
    public CodeConfig bind(@NotNull Construct _scope) {
        return (CodeConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(CodeConfig.class), (Object[])new Object[]{Objects.requireNonNull(_scope, "_scope is required")});
    }

    @NotNull
    public Boolean getIsInline() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"isInline", (NativeType)NativeType.forClass(Boolean.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3CodeV2> {
        private final IBucket bucket;
        private final String key;
        private BucketOptions.Builder options;

        public static Builder create(IBucket bucket, String key) {
            return new Builder(bucket, key);
        }

        private Builder(IBucket bucket, String key) {
            this.bucket = bucket;
            this.key = key;
        }

        public Builder objectVersion(String objectVersion) {
            this.options().objectVersion(objectVersion);
            return this;
        }

        public Builder sourceKmsKey(IKey sourceKmsKey) {
            this.options().sourceKmsKey(sourceKmsKey);
            return this;
        }

        public S3CodeV2 build() {
            return new S3CodeV2(this.bucket, this.key, this.options != null ? this.options.build() : null);
        }

        private BucketOptions.Builder options() {
            if (this.options == null) {
                this.options = new BucketOptions.Builder();
            }
            return this.options;
        }
    }
}

