/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssmquicksetup;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManager;
import software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManagerProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ssmquicksetup.CfnConfigurationManager")
public class CfnConfigurationManager
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnConfigurationManager.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnConfigurationManager(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationManager(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnConfigurationManager(@NotNull Construct scope, @NotNull String id, @NotNull CfnConfigurationManagerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLastModifiedAt() {
        return (String)Kernel.get((Object)this, (String)"attrLastModifiedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrManagerArn() {
        return (String)Kernel.get((Object)this, (String)"attrManagerArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrStatusSummaries() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrStatusSummaries", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getConfigurationDefinitions() {
        return Kernel.get((Object)this, (String)"configurationDefinitions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConfigurationDefinitions(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"configurationDefinitions", (Object)Objects.requireNonNull(value, "configurationDefinitions is required"));
    }

    public void setConfigurationDefinitions(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ConfigurationDefinitionProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManager.ConfigurationDefinitionProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"configurationDefinitions", Objects.requireNonNull(value, "configurationDefinitions is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Map<String, String> getTags() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTags(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ssmquicksetup.CfnConfigurationManager.ConfigurationDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfigurationDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getParameters();

        @NotNull
        public String getType();

        @Nullable
        default public String getId() {
            return null;
        }

        @Nullable
        default public String getLocalDeploymentAdministrationRoleArn() {
            return null;
        }

        @Nullable
        default public String getLocalDeploymentExecutionRoleName() {
            return null;
        }

        @Nullable
        default public String getTypeVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfigurationDefinitionProperty> {
            Object parameters;
            String type;
            String id;
            String localDeploymentAdministrationRoleArn;
            String localDeploymentExecutionRoleName;
            String typeVersion;

            public Builder parameters(IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder parameters(Map<String, String> parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder localDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn) {
                this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
                return this;
            }

            public Builder localDeploymentExecutionRoleName(String localDeploymentExecutionRoleName) {
                this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
                return this;
            }

            public Builder typeVersion(String typeVersion) {
                this.typeVersion = typeVersion;
                return this;
            }

            public ConfigurationDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnConfigurationManager> {
        private final Construct scope;
        private final String id;
        private final CfnConfigurationManagerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnConfigurationManagerProps.Builder();
        }

        public Builder configurationDefinitions(IResolvable configurationDefinitions) {
            this.props.configurationDefinitions(configurationDefinitions);
            return this;
        }

        public Builder configurationDefinitions(List<? extends Object> configurationDefinitions) {
            this.props.configurationDefinitions(configurationDefinitions);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnConfigurationManager build() {
            return new CfnConfigurationManager(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ssmquicksetup.CfnConfigurationManager.StatusSummaryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StatusSummaryProperty
    extends JsiiSerializable {
        @NotNull
        public String getLastUpdatedAt();

        @NotNull
        public String getStatusType();

        @Nullable
        default public String getStatus() {
            return null;
        }

        @Nullable
        default public Object getStatusDetails() {
            return null;
        }

        @Nullable
        default public String getStatusMessage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StatusSummaryProperty> {
            String lastUpdatedAt;
            String statusType;
            String status;
            Object statusDetails;
            String statusMessage;

            public Builder lastUpdatedAt(String lastUpdatedAt) {
                this.lastUpdatedAt = lastUpdatedAt;
                return this;
            }

            public Builder statusType(String statusType) {
                this.statusType = statusType;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder statusDetails(IResolvable statusDetails) {
                this.statusDetails = statusDetails;
                return this;
            }

            public Builder statusDetails(Map<String, String> statusDetails) {
                this.statusDetails = statusDetails;
                return this;
            }

            public Builder statusMessage(String statusMessage) {
                this.statusMessage = statusMessage;
                return this;
            }

            public StatusSummaryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

