/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.batch.IComputeEnvironment;
import software.amazon.awscdk.services.batch.IJobQueue;
import software.amazon.awscdk.services.batch.ISchedulingPolicy;
import software.amazon.awscdk.services.batch.JobQueueProps;
import software.amazon.awscdk.services.batch.JobStateTimeLimitAction;
import software.amazon.awscdk.services.batch.OrderedComputeEnvironment;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.JobQueue")
public class JobQueue
extends Resource
implements IJobQueue {
    protected JobQueue(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JobQueue(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public JobQueue(@NotNull Construct scope, @NotNull String id, @Nullable JobQueueProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public JobQueue(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IJobQueue fromJobQueueArn(@NotNull Construct scope, @NotNull String id, @NotNull String jobQueueArn) {
        return (IJobQueue)JsiiObject.jsiiStaticCall(JobQueue.class, (String)"fromJobQueueArn", (NativeType)NativeType.forClass(IJobQueue.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(jobQueueArn, "jobQueueArn is required")});
    }

    @Override
    public void addComputeEnvironment(@NotNull IComputeEnvironment computeEnvironment, @NotNull Number order) {
        Kernel.call((Object)this, (String)"addComputeEnvironment", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(computeEnvironment, "computeEnvironment is required"), Objects.requireNonNull(order, "order is required")});
    }

    @Override
    @NotNull
    public List<OrderedComputeEnvironment> getComputeEnvironments() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"computeEnvironments", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(OrderedComputeEnvironment.class))));
    }

    @Override
    @NotNull
    public String getJobQueueArn() {
        return (String)Kernel.get((Object)this, (String)"jobQueueArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getJobQueueName() {
        return (String)Kernel.get((Object)this, (String)"jobQueueName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Number getPriority() {
        return (Number)Kernel.get((Object)this, (String)"priority", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Boolean getEnabled() {
        return (Boolean)Kernel.get((Object)this, (String)"enabled", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public ISchedulingPolicy getSchedulingPolicy() {
        return (ISchedulingPolicy)Kernel.get((Object)this, (String)"schedulingPolicy", (NativeType)NativeType.forClass(ISchedulingPolicy.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<JobQueue> {
        private final Construct scope;
        private final String id;
        private JobQueueProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder computeEnvironments(List<? extends OrderedComputeEnvironment> computeEnvironments) {
            this.props().computeEnvironments(computeEnvironments);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        public Builder jobQueueName(String jobQueueName) {
            this.props().jobQueueName(jobQueueName);
            return this;
        }

        public Builder jobStateTimeLimitActions(List<? extends JobStateTimeLimitAction> jobStateTimeLimitActions) {
            this.props().jobStateTimeLimitActions(jobStateTimeLimitActions);
            return this;
        }

        public Builder priority(Number priority) {
            this.props().priority(priority);
            return this;
        }

        public Builder schedulingPolicy(ISchedulingPolicy schedulingPolicy) {
            this.props().schedulingPolicy(schedulingPolicy);
            return this;
        }

        public JobQueue build() {
            return new JobQueue(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private JobQueueProps.Builder props() {
            if (this.props == null) {
                this.props = new JobQueueProps.Builder();
            }
            return this.props;
        }
    }
}

