/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront.origins;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.cloudfront.CfnDistribution;
import software.amazon.awscdk.services.cloudfront.OriginBase;
import software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy;
import software.amazon.awscdk.services.cloudfront.OriginSslPolicy;
import software.amazon.awscdk.services.cloudfront.origins.HttpOriginProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudfront_origins.HttpOrigin")
public class HttpOrigin
extends OriginBase {
    protected HttpOrigin(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpOrigin(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public HttpOrigin(@NotNull String domainName, @Nullable HttpOriginProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(domainName, "domainName is required"), props});
    }

    public HttpOrigin(@NotNull String domainName) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(domainName, "domainName is required")});
    }

    @Override
    @Nullable
    protected CfnDistribution.CustomOriginConfigProperty renderCustomOriginConfig() {
        return (CfnDistribution.CustomOriginConfigProperty)Kernel.call((Object)this, (String)"renderCustomOriginConfig", (NativeType)NativeType.forClass(CfnDistribution.CustomOriginConfigProperty.class), (Object[])new Object[0]);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<HttpOrigin> {
        private final String domainName;
        private HttpOriginProps.Builder props;

        public static Builder create(String domainName) {
            return new Builder(domainName);
        }

        private Builder(String domainName) {
            this.domainName = domainName;
        }

        public Builder connectionAttempts(Number connectionAttempts) {
            this.props().connectionAttempts(connectionAttempts);
            return this;
        }

        public Builder connectionTimeout(Duration connectionTimeout) {
            this.props().connectionTimeout(connectionTimeout);
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.props().customHeaders(customHeaders);
            return this;
        }

        public Builder originAccessControlId(String originAccessControlId) {
            this.props().originAccessControlId(originAccessControlId);
            return this;
        }

        public Builder originId(String originId) {
            this.props().originId(originId);
            return this;
        }

        public Builder originShieldEnabled(Boolean originShieldEnabled) {
            this.props().originShieldEnabled(originShieldEnabled);
            return this;
        }

        public Builder originShieldRegion(String originShieldRegion) {
            this.props().originShieldRegion(originShieldRegion);
            return this;
        }

        public Builder originPath(String originPath) {
            this.props().originPath(originPath);
            return this;
        }

        public Builder httpPort(Number httpPort) {
            this.props().httpPort(httpPort);
            return this;
        }

        public Builder httpsPort(Number httpsPort) {
            this.props().httpsPort(httpsPort);
            return this;
        }

        public Builder keepaliveTimeout(Duration keepaliveTimeout) {
            this.props().keepaliveTimeout(keepaliveTimeout);
            return this;
        }

        public Builder originSslProtocols(List<? extends OriginSslPolicy> originSslProtocols) {
            this.props().originSslProtocols(originSslProtocols);
            return this;
        }

        public Builder protocolPolicy(OriginProtocolPolicy protocolPolicy) {
            this.props().protocolPolicy(protocolPolicy);
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            this.props().readTimeout(readTimeout);
            return this;
        }

        public HttpOrigin build() {
            return new HttpOrigin(this.domainName, this.props != null ? this.props.build() : null);
        }

        private HttpOriginProps.Builder props() {
            if (this.props == null) {
                this.props = new HttpOriginProps.Builder();
            }
            return this.props;
        }
    }
}

