/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codebuild;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.codebuild.IReportGroup;
import software.amazon.awscdk.services.codebuild.ReportGroupProps;
import software.amazon.awscdk.services.codebuild.ReportGroupType;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codebuild.ReportGroup")
public class ReportGroup
extends Resource
implements IReportGroup {
    protected ReportGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReportGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ReportGroup(@NotNull Construct scope, @NotNull String id, @Nullable ReportGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public ReportGroup(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IReportGroup fromReportGroupName(@NotNull Construct scope, @NotNull String id, @NotNull String reportGroupName) {
        return (IReportGroup)JsiiObject.jsiiStaticCall(ReportGroup.class, (String)"fromReportGroupName", (NativeType)NativeType.forClass(IReportGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(reportGroupName, "reportGroupName is required")});
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public String getReportGroupArn() {
        return (String)Kernel.get((Object)this, (String)"reportGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getReportGroupName() {
        return (String)Kernel.get((Object)this, (String)"reportGroupName", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    protected IBucket getExportBucket() {
        return (IBucket)Kernel.get((Object)this, (String)"exportBucket", (NativeType)NativeType.forClass(IBucket.class));
    }

    @Nullable
    protected ReportGroupType getType() {
        return (ReportGroupType)((Object)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(ReportGroupType.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ReportGroup> {
        private final Construct scope;
        private final String id;
        private ReportGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder deleteReports(Boolean deleteReports) {
            this.props().deleteReports(deleteReports);
            return this;
        }

        public Builder exportBucket(IBucket exportBucket) {
            this.props().exportBucket(exportBucket);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public Builder reportGroupName(String reportGroupName) {
            this.props().reportGroupName(reportGroupName);
            return this;
        }

        public Builder type(ReportGroupType type) {
            this.props().type(type);
            return this;
        }

        public Builder zipExport(Boolean zipExport) {
            this.props().zipExport(zipExport);
            return this;
        }

        public ReportGroup build() {
            return new ReportGroup(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ReportGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new ReportGroupProps.Builder();
            }
            return this.props;
        }
    }
}

