/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appconfig;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.appconfig.ActionPoint;
import software.amazon.awscdk.services.appconfig.ConfigurationContent;
import software.amazon.awscdk.services.appconfig.ConfigurationType;
import software.amazon.awscdk.services.appconfig.ExtensibleBase;
import software.amazon.awscdk.services.appconfig.ExtensionOptions;
import software.amazon.awscdk.services.appconfig.HostedConfigurationProps;
import software.amazon.awscdk.services.appconfig.IApplication;
import software.amazon.awscdk.services.appconfig.IConfiguration;
import software.amazon.awscdk.services.appconfig.IDeploymentStrategy;
import software.amazon.awscdk.services.appconfig.IEnvironment;
import software.amazon.awscdk.services.appconfig.IEventDestination;
import software.amazon.awscdk.services.appconfig.IExtensible;
import software.amazon.awscdk.services.appconfig.IExtension;
import software.amazon.awscdk.services.appconfig.IValidator;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appconfig.HostedConfiguration")
public class HostedConfiguration
extends Construct
implements IConfiguration,
IExtensible {
    protected HostedConfiguration(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HostedConfiguration(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public HostedConfiguration(@NotNull Construct scope, @NotNull String id, @NotNull HostedConfigurationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    protected void addExistingEnvironmentsToApplication() {
        Kernel.call((Object)this, (String)"addExistingEnvironmentsToApplication", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Override
    public void addExtension(@NotNull IExtension extension) {
        Kernel.call((Object)this, (String)"addExtension", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(extension, "extension is required")});
    }

    @Override
    public void atDeploymentTick(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"atDeploymentTick", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void atDeploymentTick(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"atDeploymentTick", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    protected void deployConfigToEnvironments() {
        Kernel.call((Object)this, (String)"deployConfigToEnvironments", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Override
    public void on(@NotNull ActionPoint actionPoint, @NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"on", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(actionPoint, "actionPoint is required"), Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void on(@NotNull ActionPoint actionPoint, @NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"on", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(actionPoint, "actionPoint is required"), Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentBaking(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentBaking", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentBaking(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentBaking", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentComplete(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentComplete", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentComplete(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentComplete", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentRolledBack(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentRolledBack", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentRolledBack(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentRolledBack", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentStart(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentStart", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentStart(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentStart", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentStep(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentStep", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentStep(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentStep", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void preCreateHostedConfigurationVersion(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"preCreateHostedConfigurationVersion", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void preCreateHostedConfigurationVersion(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"preCreateHostedConfigurationVersion", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void preStartDeployment(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"preStartDeployment", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void preStartDeployment(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"preStartDeployment", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    @NotNull
    public IApplication getApplication() {
        return (IApplication)Kernel.get((Object)this, (String)"application", (NativeType)NativeType.forClass(IApplication.class));
    }

    @NotNull
    public String getConfigurationProfileArn() {
        return (String)Kernel.get((Object)this, (String)"configurationProfileArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getConfigurationProfileId() {
        return (String)Kernel.get((Object)this, (String)"configurationProfileId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getContent() {
        return (String)Kernel.get((Object)this, (String)"content", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getHostedConfigurationVersionArn() {
        return (String)Kernel.get((Object)this, (String)"hostedConfigurationVersionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getContentType() {
        return (String)Kernel.get((Object)this, (String)"contentType", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public IKey getDeploymentKey() {
        return (IKey)Kernel.get((Object)this, (String)"deploymentKey", (NativeType)NativeType.forClass(IKey.class));
    }

    @Override
    @Nullable
    public IDeploymentStrategy getDeploymentStrategy() {
        return (IDeploymentStrategy)Kernel.get((Object)this, (String)"deploymentStrategy", (NativeType)NativeType.forClass(IDeploymentStrategy.class));
    }

    @Override
    @Nullable
    public List<IEnvironment> getDeployTo() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"deployTo", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IEnvironment.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Override
    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public Number getLatestVersionNumber() {
        return (Number)Kernel.get((Object)this, (String)"latestVersionNumber", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public ConfigurationType getType() {
        return (ConfigurationType)((Object)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(ConfigurationType.class)));
    }

    @Override
    @Nullable
    public List<IValidator> getValidators() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"validators", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IValidator.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public String getVersionLabel() {
        return (String)Kernel.get((Object)this, (String)"versionLabel", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public String getVersionNumber() {
        return (String)Kernel.get((Object)this, (String)"versionNumber", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected String getApplicationId() {
        return (String)Kernel.get((Object)this, (String)"applicationId", (NativeType)NativeType.forClass(String.class));
    }

    protected void setApplicationId(@NotNull String value) {
        Kernel.set((Object)this, (String)"applicationId", (Object)Objects.requireNonNull(value, "applicationId is required"));
    }

    @NotNull
    protected ExtensibleBase getExtensible() {
        return (ExtensibleBase)Kernel.get((Object)this, (String)"extensible", (NativeType)NativeType.forClass(ExtensibleBase.class));
    }

    protected void setExtensible(@NotNull ExtensibleBase value) {
        Kernel.set((Object)this, (String)"extensible", (Object)Objects.requireNonNull(value, "extensible is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<HostedConfiguration> {
        private final Construct scope;
        private final String id;
        private final HostedConfigurationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new HostedConfigurationProps.Builder();
        }

        public Builder deploymentKey(IKey deploymentKey) {
            this.props.deploymentKey(deploymentKey);
            return this;
        }

        public Builder deploymentStrategy(IDeploymentStrategy deploymentStrategy) {
            this.props.deploymentStrategy(deploymentStrategy);
            return this;
        }

        public Builder deployTo(List<? extends IEnvironment> deployTo) {
            this.props.deployTo(deployTo);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder type(ConfigurationType type) {
            this.props.type(type);
            return this;
        }

        public Builder validators(List<? extends IValidator> validators) {
            this.props.validators(validators);
            return this;
        }

        public Builder application(IApplication application) {
            this.props.application(application);
            return this;
        }

        public Builder content(ConfigurationContent content) {
            this.props.content(content);
            return this;
        }

        public Builder latestVersionNumber(Number latestVersionNumber) {
            this.props.latestVersionNumber(latestVersionNumber);
            return this;
        }

        public Builder versionLabel(String versionLabel) {
            this.props.versionLabel(versionLabel);
            return this;
        }

        public HostedConfiguration build() {
            return new HostedConfiguration(this.scope, this.id, this.props.build());
        }
    }
}

