/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.ec2.CfnEC2Fleet;
import software.amazon.awscdk.services.ec2.CfnEC2FleetProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet")
public class CfnEC2Fleet
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnEC2Fleet.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnEC2Fleet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEC2Fleet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnEC2Fleet(@NotNull Construct scope, @NotNull String id, @NotNull CfnEC2FleetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrFleetId() {
        return (String)Kernel.get((Object)this, (String)"attrFleetId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getLaunchTemplateConfigs() {
        return Kernel.get((Object)this, (String)"launchTemplateConfigs", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLaunchTemplateConfigs(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"launchTemplateConfigs", (Object)Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    public void setLaunchTemplateConfigs(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof FleetLaunchTemplateConfigRequestProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"launchTemplateConfigs", Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    @NotNull
    public Object getTargetCapacitySpecification() {
        return Kernel.get((Object)this, (String)"targetCapacitySpecification", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTargetCapacitySpecification(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"targetCapacitySpecification", (Object)Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    public void setTargetCapacitySpecification(@NotNull TargetCapacitySpecificationRequestProperty value) {
        Kernel.set((Object)this, (String)"targetCapacitySpecification", (Object)Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    @Nullable
    public String getContext() {
        return (String)Kernel.get((Object)this, (String)"context", (NativeType)NativeType.forClass(String.class));
    }

    public void setContext(@Nullable String value) {
        Kernel.set((Object)this, (String)"context", (Object)value);
    }

    @Nullable
    public String getExcessCapacityTerminationPolicy() {
        return (String)Kernel.get((Object)this, (String)"excessCapacityTerminationPolicy", (NativeType)NativeType.forClass(String.class));
    }

    public void setExcessCapacityTerminationPolicy(@Nullable String value) {
        Kernel.set((Object)this, (String)"excessCapacityTerminationPolicy", (Object)value);
    }

    @Nullable
    public Object getOnDemandOptions() {
        return Kernel.get((Object)this, (String)"onDemandOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOnDemandOptions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"onDemandOptions", (Object)value);
    }

    public void setOnDemandOptions(@Nullable OnDemandOptionsRequestProperty value) {
        Kernel.set((Object)this, (String)"onDemandOptions", (Object)value);
    }

    @Nullable
    public Object getReplaceUnhealthyInstances() {
        return Kernel.get((Object)this, (String)"replaceUnhealthyInstances", (NativeType)NativeType.forClass(Object.class));
    }

    public void setReplaceUnhealthyInstances(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"replaceUnhealthyInstances", (Object)value);
    }

    public void setReplaceUnhealthyInstances(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"replaceUnhealthyInstances", (Object)value);
    }

    @Nullable
    public Object getSpotOptions() {
        return Kernel.get((Object)this, (String)"spotOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSpotOptions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"spotOptions", (Object)value);
    }

    public void setSpotOptions(@Nullable SpotOptionsRequestProperty value) {
        Kernel.set((Object)this, (String)"spotOptions", (Object)value);
    }

    @Nullable
    public Object getTagSpecifications() {
        return Kernel.get((Object)this, (String)"tagSpecifications", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTagSpecifications(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"tagSpecifications", (Object)value);
    }

    public void setTagSpecifications(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof TagSpecificationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagSpecificationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"tagSpecifications", value);
    }

    @Nullable
    public Object getTerminateInstancesWithExpiration() {
        return Kernel.get((Object)this, (String)"terminateInstancesWithExpiration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTerminateInstancesWithExpiration(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"terminateInstancesWithExpiration", (Object)value);
    }

    public void setTerminateInstancesWithExpiration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"terminateInstancesWithExpiration", (Object)value);
    }

    @Nullable
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@Nullable String value) {
        Kernel.set((Object)this, (String)"type", (Object)value);
    }

    @Nullable
    public String getValidFrom() {
        return (String)Kernel.get((Object)this, (String)"validFrom", (NativeType)NativeType.forClass(String.class));
    }

    public void setValidFrom(@Nullable String value) {
        Kernel.set((Object)this, (String)"validFrom", (Object)value);
    }

    @Nullable
    public String getValidUntil() {
        return (String)Kernel.get((Object)this, (String)"validUntil", (NativeType)NativeType.forClass(String.class));
    }

    public void setValidUntil(@Nullable String value) {
        Kernel.set((Object)this, (String)"validUntil", (Object)value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FleetLaunchTemplateConfigRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLaunchTemplateSpecification() {
            return null;
        }

        @Nullable
        default public Object getOverrides() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FleetLaunchTemplateConfigRequestProperty> {
            Object launchTemplateSpecification;
            Object overrides;

            public Builder launchTemplateSpecification(IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder launchTemplateSpecification(FleetLaunchTemplateSpecificationRequestProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder overrides(IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            public Builder overrides(List<? extends Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            public FleetLaunchTemplateConfigRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.TagSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getResourceType() {
            return null;
        }

        @Nullable
        default public List<CfnTag> getTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            String resourceType;
            List<CfnTag> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder tags(List<? extends CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public TagSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnEC2Fleet> {
        private final Construct scope;
        private final String id;
        private final CfnEC2FleetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnEC2FleetProps.Builder();
        }

        public Builder launchTemplateConfigs(IResolvable launchTemplateConfigs) {
            this.props.launchTemplateConfigs(launchTemplateConfigs);
            return this;
        }

        public Builder launchTemplateConfigs(List<? extends Object> launchTemplateConfigs) {
            this.props.launchTemplateConfigs(launchTemplateConfigs);
            return this;
        }

        public Builder targetCapacitySpecification(IResolvable targetCapacitySpecification) {
            this.props.targetCapacitySpecification(targetCapacitySpecification);
            return this;
        }

        public Builder targetCapacitySpecification(TargetCapacitySpecificationRequestProperty targetCapacitySpecification) {
            this.props.targetCapacitySpecification(targetCapacitySpecification);
            return this;
        }

        public Builder context(String context) {
            this.props.context(context);
            return this;
        }

        public Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.props.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy);
            return this;
        }

        public Builder onDemandOptions(IResolvable onDemandOptions) {
            this.props.onDemandOptions(onDemandOptions);
            return this;
        }

        public Builder onDemandOptions(OnDemandOptionsRequestProperty onDemandOptions) {
            this.props.onDemandOptions(onDemandOptions);
            return this;
        }

        public Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.props.replaceUnhealthyInstances(replaceUnhealthyInstances);
            return this;
        }

        public Builder replaceUnhealthyInstances(IResolvable replaceUnhealthyInstances) {
            this.props.replaceUnhealthyInstances(replaceUnhealthyInstances);
            return this;
        }

        public Builder spotOptions(IResolvable spotOptions) {
            this.props.spotOptions(spotOptions);
            return this;
        }

        public Builder spotOptions(SpotOptionsRequestProperty spotOptions) {
            this.props.spotOptions(spotOptions);
            return this;
        }

        public Builder tagSpecifications(IResolvable tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        public Builder tagSpecifications(List<? extends Object> tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        public Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.props.terminateInstancesWithExpiration(terminateInstancesWithExpiration);
            return this;
        }

        public Builder terminateInstancesWithExpiration(IResolvable terminateInstancesWithExpiration) {
            this.props.terminateInstancesWithExpiration(terminateInstancesWithExpiration);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder validFrom(String validFrom) {
            this.props.validFrom(validFrom);
            return this;
        }

        public Builder validUntil(String validUntil) {
            this.props.validUntil(validUntil);
            return this;
        }

        public CfnEC2Fleet build() {
            return new CfnEC2Fleet(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.VCpuCountRangeRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VCpuCountRangeRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VCpuCountRangeRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public VCpuCountRangeRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.TotalLocalStorageGBRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TotalLocalStorageGBRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TotalLocalStorageGBRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public TotalLocalStorageGBRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetCapacitySpecificationRequestProperty
    extends JsiiSerializable {
        @NotNull
        public Number getTotalTargetCapacity();

        @Nullable
        default public String getDefaultTargetCapacityType() {
            return null;
        }

        @Nullable
        default public Number getOnDemandTargetCapacity() {
            return null;
        }

        @Nullable
        default public Number getSpotTargetCapacity() {
            return null;
        }

        @Nullable
        default public String getTargetCapacityUnitType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetCapacitySpecificationRequestProperty> {
            Number totalTargetCapacity;
            String defaultTargetCapacityType;
            Number onDemandTargetCapacity;
            Number spotTargetCapacity;
            String targetCapacityUnitType;

            public Builder totalTargetCapacity(Number totalTargetCapacity) {
                this.totalTargetCapacity = totalTargetCapacity;
                return this;
            }

            public Builder defaultTargetCapacityType(String defaultTargetCapacityType) {
                this.defaultTargetCapacityType = defaultTargetCapacityType;
                return this;
            }

            public Builder onDemandTargetCapacity(Number onDemandTargetCapacity) {
                this.onDemandTargetCapacity = onDemandTargetCapacity;
                return this;
            }

            public Builder spotTargetCapacity(Number spotTargetCapacity) {
                this.spotTargetCapacity = spotTargetCapacity;
                return this;
            }

            public Builder targetCapacityUnitType(String targetCapacityUnitType) {
                this.targetCapacityUnitType = targetCapacityUnitType;
                return this;
            }

            public TargetCapacitySpecificationRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.SpotOptionsRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotOptionsRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAllocationStrategy() {
            return null;
        }

        @Nullable
        default public String getInstanceInterruptionBehavior() {
            return null;
        }

        @Nullable
        default public Number getInstancePoolsToUseCount() {
            return null;
        }

        @Nullable
        default public Object getMaintenanceStrategies() {
            return null;
        }

        @Nullable
        default public String getMaxTotalPrice() {
            return null;
        }

        @Nullable
        default public Number getMinTargetCapacity() {
            return null;
        }

        @Nullable
        default public Object getSingleAvailabilityZone() {
            return null;
        }

        @Nullable
        default public Object getSingleInstanceType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotOptionsRequestProperty> {
            String allocationStrategy;
            String instanceInterruptionBehavior;
            Number instancePoolsToUseCount;
            Object maintenanceStrategies;
            String maxTotalPrice;
            Number minTargetCapacity;
            Object singleAvailabilityZone;
            Object singleInstanceType;

            public Builder allocationStrategy(String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            public Builder instancePoolsToUseCount(Number instancePoolsToUseCount) {
                this.instancePoolsToUseCount = instancePoolsToUseCount;
                return this;
            }

            public Builder maintenanceStrategies(IResolvable maintenanceStrategies) {
                this.maintenanceStrategies = maintenanceStrategies;
                return this;
            }

            public Builder maintenanceStrategies(MaintenanceStrategiesProperty maintenanceStrategies) {
                this.maintenanceStrategies = maintenanceStrategies;
                return this;
            }

            public Builder maxTotalPrice(String maxTotalPrice) {
                this.maxTotalPrice = maxTotalPrice;
                return this;
            }

            public Builder minTargetCapacity(Number minTargetCapacity) {
                this.minTargetCapacity = minTargetCapacity;
                return this;
            }

            public Builder singleAvailabilityZone(Boolean singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            public Builder singleAvailabilityZone(IResolvable singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            public Builder singleInstanceType(Boolean singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            public Builder singleInstanceType(IResolvable singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            public SpotOptionsRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.PlacementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAffinity() {
            return null;
        }

        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public String getGroupName() {
            return null;
        }

        @Nullable
        default public String getHostId() {
            return null;
        }

        @Nullable
        default public String getHostResourceGroupArn() {
            return null;
        }

        @Nullable
        default public Number getPartitionNumber() {
            return null;
        }

        @Nullable
        default public String getSpreadDomain() {
            return null;
        }

        @Nullable
        default public String getTenancy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlacementProperty> {
            String affinity;
            String availabilityZone;
            String groupName;
            String hostId;
            String hostResourceGroupArn;
            Number partitionNumber;
            String spreadDomain;
            String tenancy;

            public Builder affinity(String affinity) {
                this.affinity = affinity;
                return this;
            }

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder hostId(String hostId) {
                this.hostId = hostId;
                return this;
            }

            public Builder hostResourceGroupArn(String hostResourceGroupArn) {
                this.hostResourceGroupArn = hostResourceGroupArn;
                return this;
            }

            public Builder partitionNumber(Number partitionNumber) {
                this.partitionNumber = partitionNumber;
                return this;
            }

            public Builder spreadDomain(String spreadDomain) {
                this.spreadDomain = spreadDomain;
                return this;
            }

            public Builder tenancy(String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            public PlacementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.PerformanceFactorReferenceRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PerformanceFactorReferenceRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public String getInstanceFamily() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PerformanceFactorReferenceRequestProperty> {
            String instanceFamily;

            public Builder instanceFamily(String instanceFamily) {
                this.instanceFamily = instanceFamily;
                return this;
            }

            public PerformanceFactorReferenceRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnDemandOptionsRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAllocationStrategy() {
            return null;
        }

        @Nullable
        default public Object getCapacityReservationOptions() {
            return null;
        }

        @Nullable
        default public String getMaxTotalPrice() {
            return null;
        }

        @Nullable
        default public Number getMinTargetCapacity() {
            return null;
        }

        @Nullable
        default public Object getSingleAvailabilityZone() {
            return null;
        }

        @Nullable
        default public Object getSingleInstanceType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnDemandOptionsRequestProperty> {
            String allocationStrategy;
            Object capacityReservationOptions;
            String maxTotalPrice;
            Number minTargetCapacity;
            Object singleAvailabilityZone;
            Object singleInstanceType;

            public Builder allocationStrategy(String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public Builder capacityReservationOptions(IResolvable capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            public Builder capacityReservationOptions(CapacityReservationOptionsRequestProperty capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            public Builder maxTotalPrice(String maxTotalPrice) {
                this.maxTotalPrice = maxTotalPrice;
                return this;
            }

            public Builder minTargetCapacity(Number minTargetCapacity) {
                this.minTargetCapacity = minTargetCapacity;
                return this;
            }

            public Builder singleAvailabilityZone(Boolean singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            public Builder singleAvailabilityZone(IResolvable singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            public Builder singleInstanceType(Boolean singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            public Builder singleInstanceType(IResolvable singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            public OnDemandOptionsRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.NetworkInterfaceCountRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkInterfaceCountRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkInterfaceCountRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public NetworkInterfaceCountRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.NetworkBandwidthGbpsRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkBandwidthGbpsRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkBandwidthGbpsRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public NetworkBandwidthGbpsRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.MemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MemoryMiBRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MemoryMiBRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public MemoryMiBRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MemoryGiBPerVCpuRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MemoryGiBPerVCpuRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public MemoryGiBPerVCpuRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.MaintenanceStrategiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MaintenanceStrategiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCapacityRebalance() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MaintenanceStrategiesProperty> {
            Object capacityRebalance;

            public Builder capacityRebalance(IResolvable capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            public Builder capacityRebalance(CapacityRebalanceProperty capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            public MaintenanceStrategiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.InstanceRequirementsRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceRequirementsRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAcceleratorCount() {
            return null;
        }

        @Nullable
        default public List<String> getAcceleratorManufacturers() {
            return null;
        }

        @Nullable
        default public List<String> getAcceleratorNames() {
            return null;
        }

        @Nullable
        default public Object getAcceleratorTotalMemoryMiB() {
            return null;
        }

        @Nullable
        default public List<String> getAcceleratorTypes() {
            return null;
        }

        @Nullable
        default public List<String> getAllowedInstanceTypes() {
            return null;
        }

        @Nullable
        default public String getBareMetal() {
            return null;
        }

        @Nullable
        default public Object getBaselineEbsBandwidthMbps() {
            return null;
        }

        @Nullable
        default public Object getBaselinePerformanceFactors() {
            return null;
        }

        @Nullable
        default public String getBurstablePerformance() {
            return null;
        }

        @Nullable
        default public List<String> getCpuManufacturers() {
            return null;
        }

        @Nullable
        default public List<String> getExcludedInstanceTypes() {
            return null;
        }

        @Nullable
        default public List<String> getInstanceGenerations() {
            return null;
        }

        @Nullable
        default public String getLocalStorage() {
            return null;
        }

        @Nullable
        default public List<String> getLocalStorageTypes() {
            return null;
        }

        @Nullable
        default public Number getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() {
            return null;
        }

        @Nullable
        default public Object getMemoryGiBPerVCpu() {
            return null;
        }

        @Nullable
        default public Object getMemoryMiB() {
            return null;
        }

        @Nullable
        default public Object getNetworkBandwidthGbps() {
            return null;
        }

        @Nullable
        default public Object getNetworkInterfaceCount() {
            return null;
        }

        @Nullable
        default public Number getOnDemandMaxPricePercentageOverLowestPrice() {
            return null;
        }

        @Nullable
        default public Object getRequireHibernateSupport() {
            return null;
        }

        @Nullable
        default public Number getSpotMaxPricePercentageOverLowestPrice() {
            return null;
        }

        @Nullable
        default public Object getTotalLocalStorageGb() {
            return null;
        }

        @Nullable
        default public Object getVCpuCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceRequirementsRequestProperty> {
            Object acceleratorCount;
            List<String> acceleratorManufacturers;
            List<String> acceleratorNames;
            Object acceleratorTotalMemoryMiB;
            List<String> acceleratorTypes;
            List<String> allowedInstanceTypes;
            String bareMetal;
            Object baselineEbsBandwidthMbps;
            Object baselinePerformanceFactors;
            String burstablePerformance;
            List<String> cpuManufacturers;
            List<String> excludedInstanceTypes;
            List<String> instanceGenerations;
            String localStorage;
            List<String> localStorageTypes;
            Number maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
            Object memoryGiBPerVCpu;
            Object memoryMiB;
            Object networkBandwidthGbps;
            Object networkInterfaceCount;
            Number onDemandMaxPricePercentageOverLowestPrice;
            Object requireHibernateSupport;
            Number spotMaxPricePercentageOverLowestPrice;
            Object totalLocalStorageGb;
            Object vCpuCount;

            public Builder acceleratorCount(IResolvable acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            public Builder acceleratorCount(AcceleratorCountRequestProperty acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            public Builder acceleratorManufacturers(List<String> acceleratorManufacturers) {
                this.acceleratorManufacturers = acceleratorManufacturers;
                return this;
            }

            public Builder acceleratorNames(List<String> acceleratorNames) {
                this.acceleratorNames = acceleratorNames;
                return this;
            }

            public Builder acceleratorTotalMemoryMiB(IResolvable acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            public Builder acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            public Builder acceleratorTypes(List<String> acceleratorTypes) {
                this.acceleratorTypes = acceleratorTypes;
                return this;
            }

            public Builder allowedInstanceTypes(List<String> allowedInstanceTypes) {
                this.allowedInstanceTypes = allowedInstanceTypes;
                return this;
            }

            public Builder bareMetal(String bareMetal) {
                this.bareMetal = bareMetal;
                return this;
            }

            public Builder baselineEbsBandwidthMbps(IResolvable baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            public Builder baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            public Builder baselinePerformanceFactors(IResolvable baselinePerformanceFactors) {
                this.baselinePerformanceFactors = baselinePerformanceFactors;
                return this;
            }

            public Builder baselinePerformanceFactors(BaselinePerformanceFactorsRequestProperty baselinePerformanceFactors) {
                this.baselinePerformanceFactors = baselinePerformanceFactors;
                return this;
            }

            public Builder burstablePerformance(String burstablePerformance) {
                this.burstablePerformance = burstablePerformance;
                return this;
            }

            public Builder cpuManufacturers(List<String> cpuManufacturers) {
                this.cpuManufacturers = cpuManufacturers;
                return this;
            }

            public Builder excludedInstanceTypes(List<String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            public Builder instanceGenerations(List<String> instanceGenerations) {
                this.instanceGenerations = instanceGenerations;
                return this;
            }

            public Builder localStorage(String localStorage) {
                this.localStorage = localStorage;
                return this;
            }

            public Builder localStorageTypes(List<String> localStorageTypes) {
                this.localStorageTypes = localStorageTypes;
                return this;
            }

            public Builder maxSpotPriceAsPercentageOfOptimalOnDemandPrice(Number maxSpotPriceAsPercentageOfOptimalOnDemandPrice) {
                this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice = maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
                return this;
            }

            public Builder memoryGiBPerVCpu(IResolvable memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            public Builder memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            public Builder memoryMiB(IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            public Builder memoryMiB(MemoryMiBRequestProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            public Builder networkBandwidthGbps(IResolvable networkBandwidthGbps) {
                this.networkBandwidthGbps = networkBandwidthGbps;
                return this;
            }

            public Builder networkBandwidthGbps(NetworkBandwidthGbpsRequestProperty networkBandwidthGbps) {
                this.networkBandwidthGbps = networkBandwidthGbps;
                return this;
            }

            public Builder networkInterfaceCount(IResolvable networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            public Builder networkInterfaceCount(NetworkInterfaceCountRequestProperty networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            public Builder onDemandMaxPricePercentageOverLowestPrice(Number onDemandMaxPricePercentageOverLowestPrice) {
                this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
                return this;
            }

            public Builder requireHibernateSupport(Boolean requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            public Builder requireHibernateSupport(IResolvable requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            public Builder spotMaxPricePercentageOverLowestPrice(Number spotMaxPricePercentageOverLowestPrice) {
                this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
                return this;
            }

            public Builder totalLocalStorageGb(IResolvable totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            public Builder totalLocalStorageGb(TotalLocalStorageGBRequestProperty totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            public Builder vCpuCount(IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            public Builder vCpuCount(VCpuCountRangeRequestProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            public InstanceRequirementsRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FleetLaunchTemplateSpecificationRequestProperty
    extends JsiiSerializable {
        @NotNull
        public String getVersion();

        @Nullable
        default public String getLaunchTemplateId() {
            return null;
        }

        @Nullable
        default public String getLaunchTemplateName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FleetLaunchTemplateSpecificationRequestProperty> {
            String version;
            String launchTemplateId;
            String launchTemplateName;

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder launchTemplateName(String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            public FleetLaunchTemplateSpecificationRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FleetLaunchTemplateOverridesRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public Object getInstanceRequirements() {
            return null;
        }

        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public String getMaxPrice() {
            return null;
        }

        @Nullable
        default public Object getPlacement() {
            return null;
        }

        @Nullable
        default public Number getPriority() {
            return null;
        }

        @Nullable
        default public String getSubnetId() {
            return null;
        }

        @Nullable
        default public Number getWeightedCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FleetLaunchTemplateOverridesRequestProperty> {
            String availabilityZone;
            Object instanceRequirements;
            String instanceType;
            String maxPrice;
            Object placement;
            Number priority;
            String subnetId;
            Number weightedCapacity;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder instanceRequirements(IResolvable instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            public Builder instanceRequirements(InstanceRequirementsRequestProperty instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder maxPrice(String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            public Builder placement(IResolvable placement) {
                this.placement = placement;
                return this;
            }

            public Builder placement(PlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            public Builder priority(Number priority) {
                this.priority = priority;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public Builder weightedCapacity(Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public FleetLaunchTemplateOverridesRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.CpuPerformanceFactorRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CpuPerformanceFactorRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getReferences() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CpuPerformanceFactorRequestProperty> {
            Object references;

            public Builder references(IResolvable references) {
                this.references = references;
                return this;
            }

            public Builder references(List<? extends Object> references) {
                this.references = references;
                return this;
            }

            public CpuPerformanceFactorRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CapacityReservationOptionsRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public String getUsageStrategy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CapacityReservationOptionsRequestProperty> {
            String usageStrategy;

            public Builder usageStrategy(String usageStrategy) {
                this.usageStrategy = usageStrategy;
                return this;
            }

            public CapacityReservationOptionsRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.CapacityRebalanceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CapacityRebalanceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getReplacementStrategy() {
            return null;
        }

        @Nullable
        default public Number getTerminationDelay() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CapacityRebalanceProperty> {
            String replacementStrategy;
            Number terminationDelay;

            public Builder replacementStrategy(String replacementStrategy) {
                this.replacementStrategy = replacementStrategy;
                return this;
            }

            public Builder terminationDelay(Number terminationDelay) {
                this.terminationDelay = terminationDelay;
                return this;
            }

            public CapacityRebalanceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.BaselinePerformanceFactorsRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BaselinePerformanceFactorsRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCpu() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BaselinePerformanceFactorsRequestProperty> {
            Object cpu;

            public Builder cpu(IResolvable cpu) {
                this.cpu = cpu;
                return this;
            }

            public Builder cpu(CpuPerformanceFactorRequestProperty cpu) {
                this.cpu = cpu;
                return this;
            }

            public BaselinePerformanceFactorsRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BaselineEbsBandwidthMbpsRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BaselineEbsBandwidthMbpsRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public BaselineEbsBandwidthMbpsRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AcceleratorTotalMemoryMiBRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AcceleratorTotalMemoryMiBRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public AcceleratorTotalMemoryMiBRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnEC2Fleet.AcceleratorCountRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AcceleratorCountRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AcceleratorCountRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public AcceleratorCountRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

