/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.eks.AccessEntryAttributes;
import software.amazon.awscdk.services.eks.AccessEntryProps;
import software.amazon.awscdk.services.eks.AccessEntryType;
import software.amazon.awscdk.services.eks.IAccessEntry;
import software.amazon.awscdk.services.eks.IAccessPolicy;
import software.amazon.awscdk.services.eks.ICluster;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_eks.AccessEntry")
public class AccessEntry
extends Resource
implements IAccessEntry {
    protected AccessEntry(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessEntry(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AccessEntry(@NotNull Construct scope, @NotNull String id, @NotNull AccessEntryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IAccessEntry fromAccessEntryAttributes(@NotNull Construct scope, @NotNull String id, @NotNull AccessEntryAttributes attrs) {
        return (IAccessEntry)JsiiObject.jsiiStaticCall(AccessEntry.class, (String)"fromAccessEntryAttributes", (NativeType)NativeType.forClass(IAccessEntry.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addAccessPolicies(@NotNull List<IAccessPolicy> newAccessPolicies) {
        Kernel.call((Object)this, (String)"addAccessPolicies", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(newAccessPolicies, "newAccessPolicies is required")});
    }

    @Override
    @NotNull
    public String getAccessEntryArn() {
        return (String)Kernel.get((Object)this, (String)"accessEntryArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getAccessEntryName() {
        return (String)Kernel.get((Object)this, (String)"accessEntryName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AccessEntry> {
        private final Construct scope;
        private final String id;
        private final AccessEntryProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new AccessEntryProps.Builder();
        }

        public Builder accessPolicies(List<? extends IAccessPolicy> accessPolicies) {
            this.props.accessPolicies(accessPolicies);
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder principal(String principal) {
            this.props.principal(principal);
            return this;
        }

        public Builder accessEntryName(String accessEntryName) {
            this.props.accessEntryName(accessEntryName);
            return this;
        }

        public Builder accessEntryType(AccessEntryType accessEntryType) {
            this.props.accessEntryType(accessEntryType);
            return this;
        }

        public AccessEntry build() {
            return new AccessEntry(this.scope, this.id, this.props.build());
        }
    }
}

