/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerAttributes;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerLookupOptions;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerRedirectConfig;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.DesyncMitigationMode;
import software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb;
import software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerMetrics;
import software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType;
import software.amazon.awscdk.services.elasticloadbalancingv2.XffHeaderProcessingMode;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer")
public class ApplicationLoadBalancer
extends BaseLoadBalancer
implements IApplicationLoadBalancer {
    protected ApplicationLoadBalancer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationLoadBalancer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ApplicationLoadBalancer(@NotNull Construct scope, @NotNull String id, @NotNull ApplicationLoadBalancerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IApplicationLoadBalancer fromApplicationLoadBalancerAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ApplicationLoadBalancerAttributes attrs) {
        return (IApplicationLoadBalancer)JsiiObject.jsiiStaticCall(ApplicationLoadBalancer.class, (String)"fromApplicationLoadBalancerAttributes", (NativeType)NativeType.forClass(IApplicationLoadBalancer.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IApplicationLoadBalancer fromLookup(@NotNull Construct scope, @NotNull String id, @NotNull ApplicationLoadBalancerLookupOptions options) {
        return (IApplicationLoadBalancer)JsiiObject.jsiiStaticCall(ApplicationLoadBalancer.class, (String)"fromLookup", (NativeType)NativeType.forClass(IApplicationLoadBalancer.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public ApplicationListener addListener(@NotNull String id, @NotNull BaseApplicationListenerProps props) {
        return (ApplicationListener)Kernel.call((Object)this, (String)"addListener", (NativeType)NativeType.forClass(ApplicationListener.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public ApplicationListener addRedirect(@Nullable ApplicationLoadBalancerRedirectConfig props) {
        return (ApplicationListener)Kernel.call((Object)this, (String)"addRedirect", (NativeType)NativeType.forClass(ApplicationListener.class), (Object[])new Object[]{props});
    }

    @NotNull
    public ApplicationListener addRedirect() {
        return (ApplicationListener)Kernel.call((Object)this, (String)"addRedirect", (NativeType)NativeType.forClass(ApplicationListener.class), (Object[])new Object[0]);
    }

    public void addSecurityGroup(@NotNull ISecurityGroup securityGroup) {
        Kernel.call((Object)this, (String)"addSecurityGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(securityGroup, "securityGroup is required")});
    }

    @Override
    public void logAccessLogs(@NotNull IBucket bucket, @Nullable String prefix) {
        Kernel.call((Object)this, (String)"logAccessLogs", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(bucket, "bucket is required"), prefix});
    }

    @Override
    public void logAccessLogs(@NotNull IBucket bucket) {
        Kernel.call((Object)this, (String)"logAccessLogs", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(bucket, "bucket is required")});
    }

    public void logConnectionLogs(@NotNull IBucket bucket, @Nullable String prefix) {
        Kernel.call((Object)this, (String)"logConnectionLogs", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(bucket, "bucket is required"), prefix});
    }

    public void logConnectionLogs(@NotNull IBucket bucket) {
        Kernel.call((Object)this, (String)"logConnectionLogs", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(bucket, "bucket is required")});
    }

    @Deprecated
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Deprecated
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Deprecated
    @NotNull
    public Metric metricActiveConnectionCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricActiveConnectionCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricActiveConnectionCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricActiveConnectionCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricClientTlsNegotiationErrorCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricClientTlsNegotiationErrorCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricClientTlsNegotiationErrorCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricClientTlsNegotiationErrorCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricConsumedLCUs(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedLCUs", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricConsumedLCUs() {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedLCUs", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricElbAuthError(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricElbAuthError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricElbAuthError() {
        return (Metric)Kernel.call((Object)this, (String)"metricElbAuthError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricElbAuthFailure(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricElbAuthFailure", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricElbAuthFailure() {
        return (Metric)Kernel.call((Object)this, (String)"metricElbAuthFailure", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricElbAuthLatency(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricElbAuthLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricElbAuthLatency() {
        return (Metric)Kernel.call((Object)this, (String)"metricElbAuthLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricElbAuthSuccess(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricElbAuthSuccess", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricElbAuthSuccess() {
        return (Metric)Kernel.call((Object)this, (String)"metricElbAuthSuccess", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricHttpCodeElb(@NotNull HttpCodeElb code, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpCodeElb", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(code, "code is required"), props});
    }

    @Deprecated
    @NotNull
    public Metric metricHttpCodeElb(@NotNull HttpCodeElb code) {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpCodeElb", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(code, "code is required")});
    }

    @Deprecated
    @NotNull
    public Metric metricHttpCodeTarget(@NotNull HttpCodeTarget code, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpCodeTarget", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(code, "code is required"), props});
    }

    @Deprecated
    @NotNull
    public Metric metricHttpCodeTarget(@NotNull HttpCodeTarget code) {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpCodeTarget", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(code, "code is required")});
    }

    @Deprecated
    @NotNull
    public Metric metricHttpFixedResponseCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpFixedResponseCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricHttpFixedResponseCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpFixedResponseCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricHttpRedirectCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpRedirectCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricHttpRedirectCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpRedirectCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricHttpRedirectUrlLimitExceededCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpRedirectUrlLimitExceededCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricHttpRedirectUrlLimitExceededCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpRedirectUrlLimitExceededCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricIpv6ProcessedBytes(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricIpv6ProcessedBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricIpv6ProcessedBytes() {
        return (Metric)Kernel.call((Object)this, (String)"metricIpv6ProcessedBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricIpv6RequestCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricIpv6RequestCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricIpv6RequestCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricIpv6RequestCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricNewConnectionCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricNewConnectionCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricNewConnectionCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricNewConnectionCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricProcessedBytes(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricProcessedBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricProcessedBytes() {
        return (Metric)Kernel.call((Object)this, (String)"metricProcessedBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricRejectedConnectionCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricRejectedConnectionCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricRejectedConnectionCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricRejectedConnectionCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricRequestCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricRequestCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricRequestCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricRequestCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricRuleEvaluations(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricRuleEvaluations", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricRuleEvaluations() {
        return (Metric)Kernel.call((Object)this, (String)"metricRuleEvaluations", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricTargetConnectionErrorCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetConnectionErrorCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricTargetConnectionErrorCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetConnectionErrorCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricTargetResponseTime(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetResponseTime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricTargetResponseTime() {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetResponseTime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricTargetTLSNegotiationErrorCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetTLSNegotiationErrorCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricTargetTLSNegotiationErrorCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetTLSNegotiationErrorCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public List<ApplicationListener> getListeners() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"listeners", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ApplicationListener.class))));
    }

    @Override
    @NotNull
    public IApplicationLoadBalancerMetrics getMetrics() {
        return (IApplicationLoadBalancerMetrics)Kernel.get((Object)this, (String)"metrics", (NativeType)NativeType.forClass(IApplicationLoadBalancerMetrics.class));
    }

    @Override
    @Nullable
    public IpAddressType getIpAddressType() {
        return (IpAddressType)((Object)Kernel.get((Object)this, (String)"ipAddressType", (NativeType)NativeType.forClass(IpAddressType.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApplicationLoadBalancer> {
        private final Construct scope;
        private final String id;
        private final ApplicationLoadBalancerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ApplicationLoadBalancerProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder crossZoneEnabled(Boolean crossZoneEnabled) {
            this.props.crossZoneEnabled(crossZoneEnabled);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder denyAllIgwTraffic(Boolean denyAllIgwTraffic) {
            this.props.denyAllIgwTraffic(denyAllIgwTraffic);
            return this;
        }

        public Builder internetFacing(Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        public Builder loadBalancerName(String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder clientKeepAlive(Duration clientKeepAlive) {
            this.props.clientKeepAlive(clientKeepAlive);
            return this;
        }

        public Builder desyncMitigationMode(DesyncMitigationMode desyncMitigationMode) {
            this.props.desyncMitigationMode(desyncMitigationMode);
            return this;
        }

        public Builder dropInvalidHeaderFields(Boolean dropInvalidHeaderFields) {
            this.props.dropInvalidHeaderFields(dropInvalidHeaderFields);
            return this;
        }

        public Builder http2Enabled(Boolean http2Enabled) {
            this.props.http2Enabled(http2Enabled);
            return this;
        }

        public Builder idleTimeout(Duration idleTimeout) {
            this.props.idleTimeout(idleTimeout);
            return this;
        }

        public Builder ipAddressType(IpAddressType ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        public Builder preserveHostHeader(Boolean preserveHostHeader) {
            this.props.preserveHostHeader(preserveHostHeader);
            return this;
        }

        public Builder preserveXffClientPort(Boolean preserveXffClientPort) {
            this.props.preserveXffClientPort(preserveXffClientPort);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder wafFailOpen(Boolean wafFailOpen) {
            this.props.wafFailOpen(wafFailOpen);
            return this;
        }

        public Builder xAmznTlsVersionAndCipherSuiteHeaders(Boolean xAmznTlsVersionAndCipherSuiteHeaders) {
            this.props.xAmznTlsVersionAndCipherSuiteHeaders(xAmznTlsVersionAndCipherSuiteHeaders);
            return this;
        }

        public Builder xffHeaderProcessingMode(XffHeaderProcessingMode xffHeaderProcessingMode) {
            this.props.xffHeaderProcessingMode(xffHeaderProcessingMode);
            return this;
        }

        public ApplicationLoadBalancer build() {
            return new ApplicationLoadBalancer(this.scope, this.id, this.props.build());
        }
    }
}

