/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.fsx;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.fsx.FileSystemAttributes;
import software.amazon.awscdk.services.fsx.FileSystemBase;
import software.amazon.awscdk.services.fsx.FileSystemTypeVersion;
import software.amazon.awscdk.services.fsx.IFileSystem;
import software.amazon.awscdk.services.fsx.LustreConfiguration;
import software.amazon.awscdk.services.fsx.LustreFileSystemProps;
import software.amazon.awscdk.services.fsx.StorageType;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_fsx.LustreFileSystem")
public class LustreFileSystem
extends FileSystemBase {
    protected LustreFileSystem(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LustreFileSystem(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LustreFileSystem(@NotNull Construct scope, @NotNull String id, @NotNull LustreFileSystemProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IFileSystem fromLustreFileSystemAttributes(@NotNull Construct scope, @NotNull String id, @NotNull FileSystemAttributes attrs) {
        return (IFileSystem)JsiiObject.jsiiStaticCall(LustreFileSystem.class, (String)"fromLustreFileSystemAttributes", (NativeType)NativeType.forClass(IFileSystem.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public String getDnsName() {
        return (String)Kernel.get((Object)this, (String)"dnsName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getFileSystemId() {
        return (String)Kernel.get((Object)this, (String)"fileSystemId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getMountName() {
        return (String)Kernel.get((Object)this, (String)"mountName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LustreFileSystem> {
        private final Construct scope;
        private final String id;
        private final LustreFileSystemProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new LustreFileSystemProps.Builder();
        }

        public Builder storageCapacityGiB(Number storageCapacityGiB) {
            this.props.storageCapacityGiB(storageCapacityGiB);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder backupId(String backupId) {
            this.props.backupId(backupId);
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.props.storageType(storageType);
            return this;
        }

        public Builder lustreConfiguration(LustreConfiguration lustreConfiguration) {
            this.props.lustreConfiguration(lustreConfiguration);
            return this;
        }

        public Builder vpcSubnet(ISubnet vpcSubnet) {
            this.props.vpcSubnet(vpcSubnet);
            return this;
        }

        public Builder fileSystemTypeVersion(FileSystemTypeVersion fileSystemTypeVersion) {
            this.props.fileSystemTypeVersion(fileSystemTypeVersion);
            return this;
        }

        public LustreFileSystem build() {
            return new LustreFileSystem(this.scope, this.id, this.props.build());
        }
    }
}

