/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.m2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.m2.CfnEnvironment;
import software.amazon.awscdk.services.m2.CfnEnvironmentProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_m2.CfnEnvironment")
public class CfnEnvironment
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnEnvironment.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnEnvironment(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEnvironment(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnEnvironment(@NotNull Construct scope, @NotNull String id, @NotNull CfnEnvironmentProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrEnvironmentArn() {
        return (String)Kernel.get((Object)this, (String)"attrEnvironmentArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEnvironmentId() {
        return (String)Kernel.get((Object)this, (String)"attrEnvironmentId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getEngineType() {
        return (String)Kernel.get((Object)this, (String)"engineType", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineType(@NotNull String value) {
        Kernel.set((Object)this, (String)"engineType", (Object)Objects.requireNonNull(value, "engineType is required"));
    }

    @NotNull
    public String getInstanceType() {
        return (String)Kernel.get((Object)this, (String)"instanceType", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceType(@NotNull String value) {
        Kernel.set((Object)this, (String)"instanceType", (Object)Objects.requireNonNull(value, "instanceType is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getEngineVersion() {
        return (String)Kernel.get((Object)this, (String)"engineVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"engineVersion", (Object)value);
    }

    @Nullable
    public Object getHighAvailabilityConfig() {
        return Kernel.get((Object)this, (String)"highAvailabilityConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHighAvailabilityConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"highAvailabilityConfig", (Object)value);
    }

    public void setHighAvailabilityConfig(@Nullable HighAvailabilityConfigProperty value) {
        Kernel.set((Object)this, (String)"highAvailabilityConfig", (Object)value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyId", (Object)value);
    }

    @Nullable
    public String getNetworkType() {
        return (String)Kernel.get((Object)this, (String)"networkType", (NativeType)NativeType.forClass(String.class));
    }

    public void setNetworkType(@Nullable String value) {
        Kernel.set((Object)this, (String)"networkType", (Object)value);
    }

    @Nullable
    public String getPreferredMaintenanceWindow() {
        return (String)Kernel.get((Object)this, (String)"preferredMaintenanceWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredMaintenanceWindow(@Nullable String value) {
        Kernel.set((Object)this, (String)"preferredMaintenanceWindow", (Object)value);
    }

    @Nullable
    public Object getPubliclyAccessible() {
        return Kernel.get((Object)this, (String)"publiclyAccessible", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPubliclyAccessible(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"publiclyAccessible", (Object)value);
    }

    public void setPubliclyAccessible(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"publiclyAccessible", (Object)value);
    }

    @Nullable
    public List<String> getSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"securityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"securityGroupIds", value);
    }

    @Nullable
    public Object getStorageConfigurations() {
        return Kernel.get((Object)this, (String)"storageConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setStorageConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"storageConfigurations", (Object)value);
    }

    public void setStorageConfigurations(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof StorageConfigurationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.m2.CfnEnvironment.StorageConfigurationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"storageConfigurations", value);
    }

    @Nullable
    public List<String> getSubnetIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"subnetIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSubnetIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"subnetIds", value);
    }

    @Nullable
    public Map<String, String> getTagsRaw() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTagsRaw(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_m2.CfnEnvironment.StorageConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StorageConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEfs() {
            return null;
        }

        @Nullable
        default public Object getFsx() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StorageConfigurationProperty> {
            Object efs;
            Object fsx;

            public Builder efs(IResolvable efs) {
                this.efs = efs;
                return this;
            }

            public Builder efs(EfsStorageConfigurationProperty efs) {
                this.efs = efs;
                return this;
            }

            public Builder fsx(IResolvable fsx) {
                this.fsx = fsx;
                return this;
            }

            public Builder fsx(FsxStorageConfigurationProperty fsx) {
                this.fsx = fsx;
                return this;
            }

            public StorageConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnEnvironment> {
        private final Construct scope;
        private final String id;
        private final CfnEnvironmentProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnEnvironmentProps.Builder();
        }

        public Builder engineType(String engineType) {
            this.props.engineType(engineType);
            return this;
        }

        public Builder instanceType(String instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder engineVersion(String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        public Builder highAvailabilityConfig(IResolvable highAvailabilityConfig) {
            this.props.highAvailabilityConfig(highAvailabilityConfig);
            return this;
        }

        public Builder highAvailabilityConfig(HighAvailabilityConfigProperty highAvailabilityConfig) {
            this.props.highAvailabilityConfig(highAvailabilityConfig);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder networkType(String networkType) {
            this.props.networkType(networkType);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder publiclyAccessible(IResolvable publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        public Builder storageConfigurations(IResolvable storageConfigurations) {
            this.props.storageConfigurations(storageConfigurations);
            return this;
        }

        public Builder storageConfigurations(List<? extends Object> storageConfigurations) {
            this.props.storageConfigurations(storageConfigurations);
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnEnvironment build() {
            return new CfnEnvironment(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_m2.CfnEnvironment.HighAvailabilityConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HighAvailabilityConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Number getDesiredCapacity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HighAvailabilityConfigProperty> {
            Number desiredCapacity;

            public Builder desiredCapacity(Number desiredCapacity) {
                this.desiredCapacity = desiredCapacity;
                return this;
            }

            public HighAvailabilityConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_m2.CfnEnvironment.FsxStorageConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FsxStorageConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getFileSystemId();

        @NotNull
        public String getMountPoint();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FsxStorageConfigurationProperty> {
            String fileSystemId;
            String mountPoint;

            public Builder fileSystemId(String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            public Builder mountPoint(String mountPoint) {
                this.mountPoint = mountPoint;
                return this;
            }

            public FsxStorageConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_m2.CfnEnvironment.EfsStorageConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EfsStorageConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getFileSystemId();

        @NotNull
        public String getMountPoint();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EfsStorageConfigurationProperty> {
            String fileSystemId;
            String mountPoint;

            public Builder fileSystemId(String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            public Builder mountPoint(String mountPoint) {
                this.mountPoint = mountPoint;
                return this;
            }

            public EfsStorageConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

