/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.route53.AlarmIdentifier;
import software.amazon.awscdk.services.route53.HealthCheckProps;
import software.amazon.awscdk.services.route53.HealthCheckType;
import software.amazon.awscdk.services.route53.IHealthCheck;
import software.amazon.awscdk.services.route53.InsufficientDataHealthStatusEnum;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_route53.HealthCheck")
public class HealthCheck
extends Resource
implements IHealthCheck {
    protected HealthCheck(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HealthCheck(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public HealthCheck(@NotNull Construct scope, @NotNull String id, @NotNull HealthCheckProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IHealthCheck fromHealthCheckId(@NotNull Construct scope, @NotNull String id, @NotNull String healthCheckId) {
        return (IHealthCheck)JsiiObject.jsiiStaticCall(HealthCheck.class, (String)"fromHealthCheckId", (NativeType)NativeType.forClass(IHealthCheck.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(healthCheckId, "healthCheckId is required")});
    }

    @Override
    @NotNull
    public String getHealthCheckId() {
        return (String)Kernel.get((Object)this, (String)"healthCheckId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<HealthCheck> {
        private final Construct scope;
        private final String id;
        private final HealthCheckProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new HealthCheckProps.Builder();
        }

        public Builder type(HealthCheckType type) {
            this.props.type(type);
            return this;
        }

        public Builder alarmIdentifier(AlarmIdentifier alarmIdentifier) {
            this.props.alarmIdentifier(alarmIdentifier);
            return this;
        }

        public Builder childHealthChecks(List<? extends IHealthCheck> childHealthChecks) {
            this.props.childHealthChecks(childHealthChecks);
            return this;
        }

        public Builder enableSni(Boolean enableSni) {
            this.props.enableSni(enableSni);
            return this;
        }

        public Builder failureThreshold(Number failureThreshold) {
            this.props.failureThreshold(failureThreshold);
            return this;
        }

        public Builder fqdn(String fqdn) {
            this.props.fqdn(fqdn);
            return this;
        }

        public Builder healthThreshold(Number healthThreshold) {
            this.props.healthThreshold(healthThreshold);
            return this;
        }

        public Builder insufficientDataHealthStatus(InsufficientDataHealthStatusEnum insufficientDataHealthStatus) {
            this.props.insufficientDataHealthStatus(insufficientDataHealthStatus);
            return this;
        }

        public Builder inverted(Boolean inverted) {
            this.props.inverted(inverted);
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.props.ipAddress(ipAddress);
            return this;
        }

        public Builder measureLatency(Boolean measureLatency) {
            this.props.measureLatency(measureLatency);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder regions(List<String> regions) {
            this.props.regions(regions);
            return this;
        }

        public Builder requestInterval(Duration requestInterval) {
            this.props.requestInterval(requestInterval);
            return this;
        }

        public Builder resourcePath(String resourcePath) {
            this.props.resourcePath(resourcePath);
            return this;
        }

        public Builder routingControl(String routingControl) {
            this.props.routingControl(routingControl);
            return this;
        }

        public Builder searchString(String searchString) {
            this.props.searchString(searchString);
            return this;
        }

        public HealthCheck build() {
            return new HealthCheck(this.scope, this.id, this.props.build());
        }
    }
}

