/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.batch.EcsFargateContainerDefinitionProps;
import software.amazon.awscdk.services.batch.EcsVolume;
import software.amazon.awscdk.services.batch.IEcsContainerDefinition;
import software.amazon.awscdk.services.batch.IEcsFargateContainerDefinition;
import software.amazon.awscdk.services.batch.LinuxParameters;
import software.amazon.awscdk.services.batch.Secret;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.CpuArchitecture;
import software.amazon.awscdk.services.ecs.FargatePlatformVersion;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.LogDriverConfig;
import software.amazon.awscdk.services.ecs.OperatingSystemFamily;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_batch.EcsFargateContainerDefinition")
public class EcsFargateContainerDefinition
extends Construct
implements IEcsFargateContainerDefinition,
IEcsContainerDefinition {
    protected EcsFargateContainerDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsFargateContainerDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EcsFargateContainerDefinition(@NotNull Construct scope, @NotNull String id, @NotNull EcsFargateContainerDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void addVolume(@NotNull EcsVolume volume) {
        Kernel.call((Object)this, (String)"addVolume", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(volume, "volume is required")});
    }

    @Override
    @NotNull
    public Number getCpu() {
        return (Number)Kernel.get((Object)this, (String)"cpu", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @NotNull
    public IRole getExecutionRole() {
        return (IRole)Kernel.get((Object)this, (String)"executionRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @NotNull
    public ContainerImage getImage() {
        return (ContainerImage)((Object)Kernel.get((Object)this, (String)"image", (NativeType)NativeType.forClass(ContainerImage.class)));
    }

    @Override
    @NotNull
    public Size getMemory() {
        return (Size)((Object)Kernel.get((Object)this, (String)"memory", (NativeType)NativeType.forClass(Size.class)));
    }

    @Override
    @NotNull
    public List<EcsVolume> getVolumes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"volumes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(EcsVolume.class))));
    }

    @Override
    @Nullable
    public Boolean getAssignPublicIp() {
        return (Boolean)Kernel.get((Object)this, (String)"assignPublicIp", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public List<String> getCommand() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"command", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Override
    @Nullable
    public Map<String, String> getEnvironment() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"environment", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Override
    @Nullable
    public Size getEphemeralStorageSize() {
        return (Size)((Object)Kernel.get((Object)this, (String)"ephemeralStorageSize", (NativeType)NativeType.forClass(Size.class)));
    }

    @Override
    @Nullable
    public CpuArchitecture getFargateCpuArchitecture() {
        return (CpuArchitecture)((Object)Kernel.get((Object)this, (String)"fargateCpuArchitecture", (NativeType)NativeType.forClass(CpuArchitecture.class)));
    }

    @Override
    @Nullable
    public OperatingSystemFamily getFargateOperatingSystemFamily() {
        return (OperatingSystemFamily)((Object)Kernel.get((Object)this, (String)"fargateOperatingSystemFamily", (NativeType)NativeType.forClass(OperatingSystemFamily.class)));
    }

    @Override
    @Nullable
    public FargatePlatformVersion getFargatePlatformVersion() {
        return (FargatePlatformVersion)((Object)Kernel.get((Object)this, (String)"fargatePlatformVersion", (NativeType)NativeType.forClass(FargatePlatformVersion.class)));
    }

    @Override
    @Nullable
    public IRole getJobRole() {
        return (IRole)Kernel.get((Object)this, (String)"jobRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @Nullable
    public LinuxParameters getLinuxParameters() {
        return (LinuxParameters)((Object)Kernel.get((Object)this, (String)"linuxParameters", (NativeType)NativeType.forClass(LinuxParameters.class)));
    }

    @Override
    @Nullable
    public LogDriverConfig getLogDriverConfig() {
        return (LogDriverConfig)Kernel.get((Object)this, (String)"logDriverConfig", (NativeType)NativeType.forClass(LogDriverConfig.class));
    }

    @Override
    @Nullable
    public Boolean getReadonlyRootFilesystem() {
        return (Boolean)Kernel.get((Object)this, (String)"readonlyRootFilesystem", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public Map<String, Secret> getSecrets() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"secrets", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Secret.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Override
    @Nullable
    public String getUser() {
        return (String)Kernel.get((Object)this, (String)"user", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EcsFargateContainerDefinition> {
        private final Construct scope;
        private final String id;
        private final EcsFargateContainerDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EcsFargateContainerDefinitionProps.Builder();
        }

        public Builder cpu(Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        public Builder image(ContainerImage image) {
            this.props.image(image);
            return this;
        }

        public Builder memory(Size memory) {
            this.props.memory(memory);
            return this;
        }

        public Builder command(List<String> command) {
            this.props.command(command);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder executionRole(IRole executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        public Builder jobRole(IRole jobRole) {
            this.props.jobRole(jobRole);
            return this;
        }

        public Builder linuxParameters(LinuxParameters linuxParameters) {
            this.props.linuxParameters(linuxParameters);
            return this;
        }

        public Builder logging(LogDriver logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.props.readonlyRootFilesystem(readonlyRootFilesystem);
            return this;
        }

        public Builder secrets(Map<String, ? extends Secret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        public Builder user(String user) {
            this.props.user(user);
            return this;
        }

        public Builder volumes(List<? extends EcsVolume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        public Builder assignPublicIp(Boolean assignPublicIp) {
            this.props.assignPublicIp(assignPublicIp);
            return this;
        }

        public Builder ephemeralStorageSize(Size ephemeralStorageSize) {
            this.props.ephemeralStorageSize(ephemeralStorageSize);
            return this;
        }

        public Builder fargateCpuArchitecture(CpuArchitecture fargateCpuArchitecture) {
            this.props.fargateCpuArchitecture(fargateCpuArchitecture);
            return this;
        }

        public Builder fargateOperatingSystemFamily(OperatingSystemFamily fargateOperatingSystemFamily) {
            this.props.fargateOperatingSystemFamily(fargateOperatingSystemFamily);
            return this;
        }

        public Builder fargatePlatformVersion(FargatePlatformVersion fargatePlatformVersion) {
            this.props.fargatePlatformVersion(fargatePlatformVersion);
            return this;
        }

        public EcsFargateContainerDefinition build() {
            return new EcsFargateContainerDefinition(this.scope, this.id, this.props.build());
        }
    }
}

