/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.ec2.CfnVPCEndpoint;
import software.amazon.awscdk.services.ec2.CfnVPCEndpointProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnVPCEndpoint")
public class CfnVPCEndpoint
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnVPCEndpoint.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnVPCEndpoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVPCEndpoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnVPCEndpoint(@NotNull Construct scope, @NotNull String id, @NotNull CfnVPCEndpointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreationTimestamp() {
        return (String)Kernel.get((Object)this, (String)"attrCreationTimestamp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getAttrDnsEntries() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"attrDnsEntries", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getAttrNetworkInterfaceIds() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"attrNetworkInterfaceIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getVpcId() {
        return (String)Kernel.get((Object)this, (String)"vpcId", (NativeType)NativeType.forClass(String.class));
    }

    public void setVpcId(@NotNull String value) {
        Kernel.set((Object)this, (String)"vpcId", (Object)Objects.requireNonNull(value, "vpcId is required"));
    }

    @Nullable
    public Object getDnsOptions() {
        return Kernel.get((Object)this, (String)"dnsOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDnsOptions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"dnsOptions", (Object)value);
    }

    public void setDnsOptions(@Nullable DnsOptionsSpecificationProperty value) {
        Kernel.set((Object)this, (String)"dnsOptions", (Object)value);
    }

    @Nullable
    public String getIpAddressType() {
        return (String)Kernel.get((Object)this, (String)"ipAddressType", (NativeType)NativeType.forClass(String.class));
    }

    public void setIpAddressType(@Nullable String value) {
        Kernel.set((Object)this, (String)"ipAddressType", (Object)value);
    }

    @Nullable
    public Object getPolicyDocument() {
        return Kernel.get((Object)this, (String)"policyDocument", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPolicyDocument(@Nullable Object value) {
        Kernel.set((Object)this, (String)"policyDocument", (Object)value);
    }

    @Nullable
    public Object getPrivateDnsEnabled() {
        return Kernel.get((Object)this, (String)"privateDnsEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPrivateDnsEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"privateDnsEnabled", (Object)value);
    }

    public void setPrivateDnsEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"privateDnsEnabled", (Object)value);
    }

    @Nullable
    public String getResourceConfigurationArn() {
        return (String)Kernel.get((Object)this, (String)"resourceConfigurationArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setResourceConfigurationArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"resourceConfigurationArn", (Object)value);
    }

    @Nullable
    public List<String> getRouteTableIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"routeTableIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setRouteTableIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"routeTableIds", value);
    }

    @Nullable
    public List<String> getSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"securityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"securityGroupIds", value);
    }

    @Nullable
    public String getServiceName() {
        return (String)Kernel.get((Object)this, (String)"serviceName", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceName(@Nullable String value) {
        Kernel.set((Object)this, (String)"serviceName", (Object)value);
    }

    @Nullable
    public String getServiceNetworkArn() {
        return (String)Kernel.get((Object)this, (String)"serviceNetworkArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceNetworkArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"serviceNetworkArn", (Object)value);
    }

    @Nullable
    public List<String> getSubnetIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"subnetIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSubnetIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"subnetIds", value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Nullable
    public String getVpcEndpointType() {
        return (String)Kernel.get((Object)this, (String)"vpcEndpointType", (NativeType)NativeType.forClass(String.class));
    }

    public void setVpcEndpointType(@Nullable String value) {
        Kernel.set((Object)this, (String)"vpcEndpointType", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnVPCEndpoint> {
        private final Construct scope;
        private final String id;
        private final CfnVPCEndpointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnVPCEndpointProps.Builder();
        }

        public Builder vpcId(String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        public Builder dnsOptions(IResolvable dnsOptions) {
            this.props.dnsOptions(dnsOptions);
            return this;
        }

        public Builder dnsOptions(DnsOptionsSpecificationProperty dnsOptions) {
            this.props.dnsOptions(dnsOptions);
            return this;
        }

        public Builder ipAddressType(String ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        public Builder policyDocument(Object policyDocument) {
            this.props.policyDocument(policyDocument);
            return this;
        }

        public Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.props.privateDnsEnabled(privateDnsEnabled);
            return this;
        }

        public Builder privateDnsEnabled(IResolvable privateDnsEnabled) {
            this.props.privateDnsEnabled(privateDnsEnabled);
            return this;
        }

        public Builder resourceConfigurationArn(String resourceConfigurationArn) {
            this.props.resourceConfigurationArn(resourceConfigurationArn);
            return this;
        }

        public Builder routeTableIds(List<String> routeTableIds) {
            this.props.routeTableIds(routeTableIds);
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        public Builder serviceNetworkArn(String serviceNetworkArn) {
            this.props.serviceNetworkArn(serviceNetworkArn);
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcEndpointType(String vpcEndpointType) {
            this.props.vpcEndpointType(vpcEndpointType);
            return this;
        }

        public CfnVPCEndpoint build() {
            return new CfnVPCEndpoint(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnVPCEndpoint.DnsOptionsSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DnsOptionsSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDnsRecordIpType() {
            return null;
        }

        @Nullable
        default public String getPrivateDnsOnlyForInboundResolverEndpoint() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DnsOptionsSpecificationProperty> {
            String dnsRecordIpType;
            String privateDnsOnlyForInboundResolverEndpoint;

            public Builder dnsRecordIpType(String dnsRecordIpType) {
                this.dnsRecordIpType = dnsRecordIpType;
                return this;
            }

            public Builder privateDnsOnlyForInboundResolverEndpoint(String privateDnsOnlyForInboundResolverEndpoint) {
                this.privateDnsOnlyForInboundResolverEndpoint = privateDnsOnlyForInboundResolverEndpoint;
                return this;
            }

            public DnsOptionsSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

