/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.opensearchservice;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.opensearchservice.CfnApplication;
import software.amazon.awscdk.services.opensearchservice.CfnApplicationProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_opensearchservice.CfnApplication")
public class CfnApplication
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplication.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnApplication(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplication(@NotNull Construct scope, @NotNull String id, @NotNull CfnApplicationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getAppConfigs() {
        return Kernel.get((Object)this, (String)"appConfigs", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAppConfigs(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"appConfigs", (Object)value);
    }

    public void setAppConfigs(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof AppConfigProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.opensearchservice.CfnApplication.AppConfigProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"appConfigs", value);
    }

    @Nullable
    public Object getDataSources() {
        return Kernel.get((Object)this, (String)"dataSources", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDataSources(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"dataSources", (Object)value);
    }

    public void setDataSources(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof DataSourceProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.opensearchservice.CfnApplication.DataSourceProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"dataSources", value);
    }

    @Nullable
    public String getEndpoint() {
        return (String)Kernel.get((Object)this, (String)"endpoint", (NativeType)NativeType.forClass(String.class));
    }

    public void setEndpoint(@Nullable String value) {
        Kernel.set((Object)this, (String)"endpoint", (Object)value);
    }

    @Nullable
    public Object getIamIdentityCenterOptions() {
        return Kernel.get((Object)this, (String)"iamIdentityCenterOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIamIdentityCenterOptions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"iamIdentityCenterOptions", (Object)value);
    }

    public void setIamIdentityCenterOptions(@Nullable IamIdentityCenterOptionsProperty value) {
        Kernel.set((Object)this, (String)"iamIdentityCenterOptions", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_opensearchservice.CfnApplication.AppConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AppConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AppConfigProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public AppConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_opensearchservice.CfnApplication.DataSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceArn();

        @Nullable
        default public String getDataSourceDescription() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceProperty> {
            String dataSourceArn;
            String dataSourceDescription;

            public Builder dataSourceArn(String dataSourceArn) {
                this.dataSourceArn = dataSourceArn;
                return this;
            }

            public Builder dataSourceDescription(String dataSourceDescription) {
                this.dataSourceDescription = dataSourceDescription;
                return this;
            }

            public DataSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApplication> {
        private final Construct scope;
        private final String id;
        private final CfnApplicationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApplicationProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder appConfigs(IResolvable appConfigs) {
            this.props.appConfigs(appConfigs);
            return this;
        }

        public Builder appConfigs(List<? extends Object> appConfigs) {
            this.props.appConfigs(appConfigs);
            return this;
        }

        public Builder dataSources(IResolvable dataSources) {
            this.props.dataSources(dataSources);
            return this;
        }

        public Builder dataSources(List<? extends Object> dataSources) {
            this.props.dataSources(dataSources);
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        public Builder iamIdentityCenterOptions(IResolvable iamIdentityCenterOptions) {
            this.props.iamIdentityCenterOptions(iamIdentityCenterOptions);
            return this;
        }

        public Builder iamIdentityCenterOptions(IamIdentityCenterOptionsProperty iamIdentityCenterOptions) {
            this.props.iamIdentityCenterOptions(iamIdentityCenterOptions);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnApplication build() {
            return new CfnApplication(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_opensearchservice.CfnApplication.IamIdentityCenterOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IamIdentityCenterOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public String getIamIdentityCenterInstanceArn() {
            return null;
        }

        @Nullable
        default public String getIamRoleForIdentityCenterApplicationArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IamIdentityCenterOptionsProperty> {
            Object enabled;
            String iamIdentityCenterInstanceArn;
            String iamRoleForIdentityCenterApplicationArn;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder iamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn) {
                this.iamIdentityCenterInstanceArn = iamIdentityCenterInstanceArn;
                return this;
            }

            public Builder iamRoleForIdentityCenterApplicationArn(String iamRoleForIdentityCenterApplicationArn) {
                this.iamRoleForIdentityCenterApplicationArn = iamRoleForIdentityCenterApplicationArn;
                return this;
            }

            public IamIdentityCenterOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

