/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.events.IConnection;
import software.amazon.awscdk.services.stepfunctions.Credentials;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.QueryLanguage;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.awscdk.services.stepfunctions.TaskStateJsonPathBaseProps;
import software.amazon.awscdk.services.stepfunctions.Timeout;
import software.amazon.awscdk.services.stepfunctions.tasks.HttpInvokeJsonPathProps;
import software.amazon.awscdk.services.stepfunctions.tasks.URLEncodingFormat;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.HttpInvokeJsonPathProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface HttpInvokeJsonPathProps
extends JsiiSerializable,
TaskStateJsonPathBaseProps {
    @NotNull
    public TaskInput getApiEndpoint();

    @NotNull
    public String getApiRoot();

    @NotNull
    public IConnection getConnection();

    @NotNull
    public TaskInput getMethod();

    @Nullable
    default public TaskInput getBody() {
        return null;
    }

    @Nullable
    default public TaskInput getHeaders() {
        return null;
    }

    @Nullable
    default public TaskInput getQueryStringParameters() {
        return null;
    }

    @Nullable
    default public URLEncodingFormat getUrlEncodingFormat() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<HttpInvokeJsonPathProps> {
        TaskInput apiEndpoint;
        String apiRoot;
        IConnection connection;
        TaskInput method;
        TaskInput body;
        TaskInput headers;
        TaskInput queryStringParameters;
        URLEncodingFormat urlEncodingFormat;
        String resultPath;
        Map<String, Object> resultSelector;
        String comment;
        QueryLanguage queryLanguage;
        String stateName;
        Credentials credentials;
        Duration heartbeat;
        Timeout heartbeatTimeout;
        IntegrationPattern integrationPattern;
        Timeout taskTimeout;
        Duration timeout;
        Map<String, Object> assign;
        String inputPath;
        String outputPath;

        public Builder apiEndpoint(TaskInput apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        public Builder apiRoot(String apiRoot) {
            this.apiRoot = apiRoot;
            return this;
        }

        public Builder connection(IConnection connection) {
            this.connection = connection;
            return this;
        }

        public Builder method(TaskInput method) {
            this.method = method;
            return this;
        }

        public Builder body(TaskInput body) {
            this.body = body;
            return this;
        }

        public Builder headers(TaskInput headers) {
            this.headers = headers;
            return this;
        }

        public Builder queryStringParameters(TaskInput queryStringParameters) {
            this.queryStringParameters = queryStringParameters;
            return this;
        }

        public Builder urlEncodingFormat(URLEncodingFormat urlEncodingFormat) {
            this.urlEncodingFormat = urlEncodingFormat;
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        public Builder resultSelector(Map<String, ? extends Object> resultSelector) {
            this.resultSelector = resultSelector;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder queryLanguage(QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        public Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Deprecated
        public Builder heartbeat(Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        public Builder heartbeatTimeout(Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public Builder taskTimeout(Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        @Deprecated
        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder assign(Map<String, ? extends Object> assign) {
            this.assign = assign;
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public HttpInvokeJsonPathProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

