/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceUsageType {
    VOICE("VOICE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceUsageType> VALUE_MAP;
    private final String value;

    private DeviceUsageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceUsageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceUsageType> knownValues() {
        EnumSet<DeviceUsageType> knownValues = EnumSet.allOf(DeviceUsageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceUsageType.class, DeviceUsageType::toString);
    }
}

