/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit;
import software.amazon.awssdk.services.alexaforbusiness.model.MeetingRoomConfiguration;
import software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit;
import software.amazon.awssdk.services.alexaforbusiness.model.WakeWord;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Profile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Profile> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileArn").getter(Profile.getter(Profile::profileArn)).setter(Profile.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()}).build();
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileName").getter(Profile.getter(Profile::profileName)).setter(Profile.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(Profile.getter(Profile::isDefault)).setter(Profile.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(Profile.getter(Profile::address)).setter(Profile.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(Profile.getter(Profile::timezone)).setter(Profile.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistanceUnit").getter(Profile.getter(Profile::distanceUnitAsString)).setter(Profile.setter(Builder::distanceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()}).build();
    private static final SdkField<String> TEMPERATURE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemperatureUnit").getter(Profile.getter(Profile::temperatureUnitAsString)).setter(Profile.setter(Builder::temperatureUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemperatureUnit").build()}).build();
    private static final SdkField<String> WAKE_WORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WakeWord").getter(Profile.getter(Profile::wakeWordAsString)).setter(Profile.setter(Builder::wakeWord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WakeWord").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locale").getter(Profile.getter(Profile::locale)).setter(Profile.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()}).build();
    private static final SdkField<Boolean> SETUP_MODE_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SetupModeDisabled").getter(Profile.getter(Profile::setupModeDisabled)).setter(Profile.setter(Builder::setupModeDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetupModeDisabled").build()}).build();
    private static final SdkField<Integer> MAX_VOLUME_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxVolumeLimit").getter(Profile.getter(Profile::maxVolumeLimit)).setter(Profile.setter(Builder::maxVolumeLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxVolumeLimit").build()}).build();
    private static final SdkField<Boolean> PSTN_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PSTNEnabled").getter(Profile.getter(Profile::pstnEnabled)).setter(Profile.setter(Builder::pstnEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PSTNEnabled").build()}).build();
    private static final SdkField<Boolean> DATA_RETENTION_OPT_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DataRetentionOptIn").getter(Profile.getter(Profile::dataRetentionOptIn)).setter(Profile.setter(Builder::dataRetentionOptIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionOptIn").build()}).build();
    private static final SdkField<String> ADDRESS_BOOK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressBookArn").getter(Profile.getter(Profile::addressBookArn)).setter(Profile.setter(Builder::addressBookArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressBookArn").build()}).build();
    private static final SdkField<MeetingRoomConfiguration> MEETING_ROOM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MeetingRoomConfiguration").getter(Profile.getter(Profile::meetingRoomConfiguration)).setter(Profile.setter(Builder::meetingRoomConfiguration)).constructor(MeetingRoomConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingRoomConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD, PROFILE_NAME_FIELD, IS_DEFAULT_FIELD, ADDRESS_FIELD, TIMEZONE_FIELD, DISTANCE_UNIT_FIELD, TEMPERATURE_UNIT_FIELD, WAKE_WORD_FIELD, LOCALE_FIELD, SETUP_MODE_DISABLED_FIELD, MAX_VOLUME_LIMIT_FIELD, PSTN_ENABLED_FIELD, DATA_RETENTION_OPT_IN_FIELD, ADDRESS_BOOK_ARN_FIELD, MEETING_ROOM_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String profileArn;
    private final String profileName;
    private final Boolean isDefault;
    private final String address;
    private final String timezone;
    private final String distanceUnit;
    private final String temperatureUnit;
    private final String wakeWord;
    private final String locale;
    private final Boolean setupModeDisabled;
    private final Integer maxVolumeLimit;
    private final Boolean pstnEnabled;
    private final Boolean dataRetentionOptIn;
    private final String addressBookArn;
    private final MeetingRoomConfiguration meetingRoomConfiguration;

    private Profile(BuilderImpl builder) {
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
        this.isDefault = builder.isDefault;
        this.address = builder.address;
        this.timezone = builder.timezone;
        this.distanceUnit = builder.distanceUnit;
        this.temperatureUnit = builder.temperatureUnit;
        this.wakeWord = builder.wakeWord;
        this.locale = builder.locale;
        this.setupModeDisabled = builder.setupModeDisabled;
        this.maxVolumeLimit = builder.maxVolumeLimit;
        this.pstnEnabled = builder.pstnEnabled;
        this.dataRetentionOptIn = builder.dataRetentionOptIn;
        this.addressBookArn = builder.addressBookArn;
        this.meetingRoomConfiguration = builder.meetingRoomConfiguration;
    }

    public final String profileArn() {
        return this.profileArn;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final String address() {
        return this.address;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public final String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public final TemperatureUnit temperatureUnit() {
        return TemperatureUnit.fromValue(this.temperatureUnit);
    }

    public final String temperatureUnitAsString() {
        return this.temperatureUnit;
    }

    public final WakeWord wakeWord() {
        return WakeWord.fromValue(this.wakeWord);
    }

    public final String wakeWordAsString() {
        return this.wakeWord;
    }

    public final String locale() {
        return this.locale;
    }

    public final Boolean setupModeDisabled() {
        return this.setupModeDisabled;
    }

    public final Integer maxVolumeLimit() {
        return this.maxVolumeLimit;
    }

    public final Boolean pstnEnabled() {
        return this.pstnEnabled;
    }

    public final Boolean dataRetentionOptIn() {
        return this.dataRetentionOptIn;
    }

    public final String addressBookArn() {
        return this.addressBookArn;
    }

    public final MeetingRoomConfiguration meetingRoomConfiguration() {
        return this.meetingRoomConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temperatureUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wakeWordAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.setupModeDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxVolumeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.pstnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRetentionOptIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressBookArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingRoomConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile other = (Profile)obj;
        return Objects.equals(this.profileArn(), other.profileArn()) && Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString()) && Objects.equals(this.temperatureUnitAsString(), other.temperatureUnitAsString()) && Objects.equals(this.wakeWordAsString(), other.wakeWordAsString()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.setupModeDisabled(), other.setupModeDisabled()) && Objects.equals(this.maxVolumeLimit(), other.maxVolumeLimit()) && Objects.equals(this.pstnEnabled(), other.pstnEnabled()) && Objects.equals(this.dataRetentionOptIn(), other.dataRetentionOptIn()) && Objects.equals(this.addressBookArn(), other.addressBookArn()) && Objects.equals(this.meetingRoomConfiguration(), other.meetingRoomConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Profile").add("ProfileArn", (Object)this.profileArn()).add("ProfileName", (Object)this.profileName()).add("IsDefault", (Object)this.isDefault()).add("Address", (Object)this.address()).add("Timezone", (Object)this.timezone()).add("DistanceUnit", (Object)this.distanceUnitAsString()).add("TemperatureUnit", (Object)this.temperatureUnitAsString()).add("WakeWord", (Object)this.wakeWordAsString()).add("Locale", (Object)this.locale()).add("SetupModeDisabled", (Object)this.setupModeDisabled()).add("MaxVolumeLimit", (Object)this.maxVolumeLimit()).add("PSTNEnabled", (Object)this.pstnEnabled()).add("DataRetentionOptIn", (Object)this.dataRetentionOptIn()).add("AddressBookArn", (Object)this.addressBookArn()).add("MeetingRoomConfiguration", (Object)this.meetingRoomConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
            case "ProfileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
            case "TemperatureUnit": {
                return Optional.ofNullable(clazz.cast(this.temperatureUnitAsString()));
            }
            case "WakeWord": {
                return Optional.ofNullable(clazz.cast(this.wakeWordAsString()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "SetupModeDisabled": {
                return Optional.ofNullable(clazz.cast(this.setupModeDisabled()));
            }
            case "MaxVolumeLimit": {
                return Optional.ofNullable(clazz.cast(this.maxVolumeLimit()));
            }
            case "PSTNEnabled": {
                return Optional.ofNullable(clazz.cast(this.pstnEnabled()));
            }
            case "DataRetentionOptIn": {
                return Optional.ofNullable(clazz.cast(this.dataRetentionOptIn()));
            }
            case "AddressBookArn": {
                return Optional.ofNullable(clazz.cast(this.addressBookArn()));
            }
            case "MeetingRoomConfiguration": {
                return Optional.ofNullable(clazz.cast(this.meetingRoomConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Profile, T> g) {
        return obj -> g.apply((Profile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileArn;
        private String profileName;
        private Boolean isDefault;
        private String address;
        private String timezone;
        private String distanceUnit;
        private String temperatureUnit;
        private String wakeWord;
        private String locale;
        private Boolean setupModeDisabled;
        private Integer maxVolumeLimit;
        private Boolean pstnEnabled;
        private Boolean dataRetentionOptIn;
        private String addressBookArn;
        private MeetingRoomConfiguration meetingRoomConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Profile model) {
            this.profileArn(model.profileArn);
            this.profileName(model.profileName);
            this.isDefault(model.isDefault);
            this.address(model.address);
            this.timezone(model.timezone);
            this.distanceUnit(model.distanceUnit);
            this.temperatureUnit(model.temperatureUnit);
            this.wakeWord(model.wakeWord);
            this.locale(model.locale);
            this.setupModeDisabled(model.setupModeDisabled);
            this.maxVolumeLimit(model.maxVolumeLimit);
            this.pstnEnabled(model.pstnEnabled);
            this.dataRetentionOptIn(model.dataRetentionOptIn);
            this.addressBookArn(model.addressBookArn);
            this.meetingRoomConfiguration(model.meetingRoomConfiguration);
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getProfileName() {
            return this.profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getDistanceUnit() {
            return this.distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final String getTemperatureUnit() {
            return this.temperatureUnit;
        }

        public final void setTemperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
        }

        @Override
        public final Builder temperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
            return this;
        }

        @Override
        public final Builder temperatureUnit(TemperatureUnit temperatureUnit) {
            this.temperatureUnit(temperatureUnit == null ? null : temperatureUnit.toString());
            return this;
        }

        public final String getWakeWord() {
            return this.wakeWord;
        }

        public final void setWakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
        }

        @Override
        public final Builder wakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
            return this;
        }

        @Override
        public final Builder wakeWord(WakeWord wakeWord) {
            this.wakeWord(wakeWord == null ? null : wakeWord.toString());
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final Boolean getSetupModeDisabled() {
            return this.setupModeDisabled;
        }

        public final void setSetupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
        }

        @Override
        @Transient
        public final Builder setupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
            return this;
        }

        public final Integer getMaxVolumeLimit() {
            return this.maxVolumeLimit;
        }

        public final void setMaxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
        }

        @Override
        public final Builder maxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
            return this;
        }

        public final Boolean getPstnEnabled() {
            return this.pstnEnabled;
        }

        public final void setPstnEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
        }

        @Override
        public final Builder pstnEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
            return this;
        }

        public final Boolean getDataRetentionOptIn() {
            return this.dataRetentionOptIn;
        }

        public final void setDataRetentionOptIn(Boolean dataRetentionOptIn) {
            this.dataRetentionOptIn = dataRetentionOptIn;
        }

        @Override
        public final Builder dataRetentionOptIn(Boolean dataRetentionOptIn) {
            this.dataRetentionOptIn = dataRetentionOptIn;
            return this;
        }

        public final String getAddressBookArn() {
            return this.addressBookArn;
        }

        public final void setAddressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
        }

        @Override
        public final Builder addressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
            return this;
        }

        public final MeetingRoomConfiguration.Builder getMeetingRoomConfiguration() {
            return this.meetingRoomConfiguration != null ? this.meetingRoomConfiguration.toBuilder() : null;
        }

        public final void setMeetingRoomConfiguration(MeetingRoomConfiguration.BuilderImpl meetingRoomConfiguration) {
            this.meetingRoomConfiguration = meetingRoomConfiguration != null ? meetingRoomConfiguration.build() : null;
        }

        @Override
        public final Builder meetingRoomConfiguration(MeetingRoomConfiguration meetingRoomConfiguration) {
            this.meetingRoomConfiguration = meetingRoomConfiguration;
            return this;
        }

        public Profile build() {
            return new Profile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Profile> {
        public Builder profileArn(String var1);

        public Builder profileName(String var1);

        public Builder isDefault(Boolean var1);

        public Builder address(String var1);

        public Builder timezone(String var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);

        public Builder temperatureUnit(String var1);

        public Builder temperatureUnit(TemperatureUnit var1);

        public Builder wakeWord(String var1);

        public Builder wakeWord(WakeWord var1);

        public Builder locale(String var1);

        public Builder setupModeDisabled(Boolean var1);

        public Builder maxVolumeLimit(Integer var1);

        public Builder pstnEnabled(Boolean var1);

        public Builder dataRetentionOptIn(Boolean var1);

        public Builder addressBookArn(String var1);

        public Builder meetingRoomConfiguration(MeetingRoomConfiguration var1);

        default public Builder meetingRoomConfiguration(Consumer<MeetingRoomConfiguration.Builder> meetingRoomConfiguration) {
            return this.meetingRoomConfiguration((MeetingRoomConfiguration)((MeetingRoomConfiguration.Builder)MeetingRoomConfiguration.builder().applyMutation(meetingRoomConfiguration)).build());
        }
    }
}

