/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse;

public class ListGatewaysIterable
implements SdkIterable<ListGatewaysResponse> {
    private final AlexaForBusinessClient client;
    private final ListGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGatewaysIterable(AlexaForBusinessClient client, ListGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGatewaysResponseFetcher();
    }

    public Iterator<ListGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListGatewaysResponseFetcher
    implements SyncPageFetcher<ListGatewaysResponse> {
        private ListGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGatewaysResponse nextPage(ListGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListGatewaysIterable.this.client.listGateways(ListGatewaysIterable.this.firstRequest);
            }
            return ListGatewaysIterable.this.client.listGateways((ListGatewaysRequest)((Object)ListGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

