/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse;

public class SearchSkillGroupsIterable
implements SdkIterable<SearchSkillGroupsResponse> {
    private final AlexaForBusinessClient client;
    private final SearchSkillGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchSkillGroupsIterable(AlexaForBusinessClient client, SearchSkillGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchSkillGroupsResponseFetcher();
    }

    public Iterator<SearchSkillGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchSkillGroupsResponseFetcher
    implements SyncPageFetcher<SearchSkillGroupsResponse> {
        private SearchSkillGroupsResponseFetcher() {
        }

        public boolean hasNextPage(SearchSkillGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchSkillGroupsResponse nextPage(SearchSkillGroupsResponse previousPage) {
            if (previousPage == null) {
                return SearchSkillGroupsIterable.this.client.searchSkillGroups(SearchSkillGroupsIterable.this.firstRequest);
            }
            return SearchSkillGroupsIterable.this.client.searchSkillGroups((SearchSkillGroupsRequest)((Object)SearchSkillGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

