/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.S3Location;

final class S3LocationListCopier {
    S3LocationListCopier() {
    }

    static List<S3Location> copy(Collection<? extends S3Location> s3LocationListParam) {
        Object list;
        if (s3LocationListParam == null || s3LocationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            s3LocationListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3Location> copyFromBuilder(Collection<? extends S3Location.Builder> s3LocationListParam) {
        Object list;
        if (s3LocationListParam == null || s3LocationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            s3LocationListParam.forEach(entry -> {
                S3Location member = entry == null ? null : (S3Location)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3Location.Builder> copyToBuilder(Collection<? extends S3Location> s3LocationListParam) {
        Object list;
        if (s3LocationListParam == null || s3LocationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            s3LocationListParam.forEach(entry -> {
                S3Location.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

