/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.AdditionalModelRequestFieldsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.InferenceConfig;
import software.amazon.awssdk.services.bedrockagentruntime.model.PromptTemplate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalSourcesGenerationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalSourcesGenerationConfiguration> {
    private static final SdkField<Map<String, Document>> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalModelRequestFields").getter(ExternalSourcesGenerationConfiguration.getter(ExternalSourcesGenerationConfiguration::additionalModelRequestFields)).setter(ExternalSourcesGenerationConfiguration.setter(Builder::additionalModelRequestFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfiguration").getter(ExternalSourcesGenerationConfiguration.getter(ExternalSourcesGenerationConfiguration::guardrailConfiguration)).setter(ExternalSourcesGenerationConfiguration.setter(Builder::guardrailConfiguration)).constructor(GuardrailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build()}).build();
    private static final SdkField<InferenceConfig> INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfig").getter(ExternalSourcesGenerationConfiguration.getter(ExternalSourcesGenerationConfiguration::inferenceConfig)).setter(ExternalSourcesGenerationConfiguration.setter(Builder::inferenceConfig)).constructor(InferenceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()}).build();
    private static final SdkField<PromptTemplate> PROMPT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptTemplate").getter(ExternalSourcesGenerationConfiguration.getter(ExternalSourcesGenerationConfiguration::promptTemplate)).setter(ExternalSourcesGenerationConfiguration.setter(Builder::promptTemplate)).constructor(PromptTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD, GUARDRAIL_CONFIGURATION_FIELD, INFERENCE_CONFIG_FIELD, PROMPT_TEMPLATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, Document> additionalModelRequestFields;
    private final GuardrailConfiguration guardrailConfiguration;
    private final InferenceConfig inferenceConfig;
    private final PromptTemplate promptTemplate;

    private ExternalSourcesGenerationConfiguration(BuilderImpl builder) {
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.inferenceConfig = builder.inferenceConfig;
        this.promptTemplate = builder.promptTemplate;
    }

    public final boolean hasAdditionalModelRequestFields() {
        return this.additionalModelRequestFields != null && !(this.additionalModelRequestFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, Document> additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public final GuardrailConfiguration guardrailConfiguration() {
        return this.guardrailConfiguration;
    }

    public final InferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    public final PromptTemplate promptTemplate() {
        return this.promptTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalModelRequestFields() ? this.additionalModelRequestFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptTemplate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalSourcesGenerationConfiguration)) {
            return false;
        }
        ExternalSourcesGenerationConfiguration other = (ExternalSourcesGenerationConfiguration)obj;
        return this.hasAdditionalModelRequestFields() == other.hasAdditionalModelRequestFields() && Objects.equals(this.additionalModelRequestFields(), other.additionalModelRequestFields()) && Objects.equals(this.guardrailConfiguration(), other.guardrailConfiguration()) && Objects.equals(this.inferenceConfig(), other.inferenceConfig()) && Objects.equals(this.promptTemplate(), other.promptTemplate());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalSourcesGenerationConfiguration").add("AdditionalModelRequestFields", this.hasAdditionalModelRequestFields() ? this.additionalModelRequestFields() : null).add("GuardrailConfiguration", (Object)this.guardrailConfiguration()).add("InferenceConfig", (Object)this.inferenceConfig()).add("PromptTemplate", (Object)this.promptTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalModelRequestFields": {
                return Optional.ofNullable(clazz.cast(this.additionalModelRequestFields()));
            }
            case "guardrailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfiguration()));
            }
            case "inferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfig()));
            }
            case "promptTemplate": {
                return Optional.ofNullable(clazz.cast(this.promptTemplate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalSourcesGenerationConfiguration, T> g) {
        return obj -> g.apply((ExternalSourcesGenerationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Document> additionalModelRequestFields = DefaultSdkAutoConstructMap.getInstance();
        private GuardrailConfiguration guardrailConfiguration;
        private InferenceConfig inferenceConfig;
        private PromptTemplate promptTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalSourcesGenerationConfiguration model) {
            this.additionalModelRequestFields(model.additionalModelRequestFields);
            this.guardrailConfiguration(model.guardrailConfiguration);
            this.inferenceConfig(model.inferenceConfig);
            this.promptTemplate(model.promptTemplate);
        }

        public final Map<String, Document> getAdditionalModelRequestFields() {
            if (this.additionalModelRequestFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
        }

        @Override
        public final Builder additionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
            return this;
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return this.guardrailConfiguration != null ? this.guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final InferenceConfig.Builder getInferenceConfig() {
            return this.inferenceConfig != null ? this.inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(InferenceConfig.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(InferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final PromptTemplate.Builder getPromptTemplate() {
            return this.promptTemplate != null ? this.promptTemplate.toBuilder() : null;
        }

        public final void setPromptTemplate(PromptTemplate.BuilderImpl promptTemplate) {
            this.promptTemplate = promptTemplate != null ? promptTemplate.build() : null;
        }

        @Override
        public final Builder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public ExternalSourcesGenerationConfiguration build() {
            return new ExternalSourcesGenerationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalSourcesGenerationConfiguration> {
        public Builder additionalModelRequestFields(Map<String, Document> var1);

        public Builder guardrailConfiguration(GuardrailConfiguration var1);

        default public Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return this.guardrailConfiguration((GuardrailConfiguration)((GuardrailConfiguration.Builder)GuardrailConfiguration.builder().applyMutation(guardrailConfiguration)).build());
        }

        public Builder inferenceConfig(InferenceConfig var1);

        default public Builder inferenceConfig(Consumer<InferenceConfig.Builder> inferenceConfig) {
            return this.inferenceConfig((InferenceConfig)((InferenceConfig.Builder)InferenceConfig.builder().applyMutation(inferenceConfig)).build());
        }

        public Builder promptTemplate(PromptTemplate var1);

        default public Builder promptTemplate(Consumer<PromptTemplate.Builder> promptTemplate) {
            return this.promptTemplate((PromptTemplate)((PromptTemplate.Builder)PromptTemplate.builder().applyMutation(promptTemplate)).build());
        }
    }
}

