/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.FunctionParameter;
import software.amazon.awssdk.services.bedrockagentruntime.model.FunctionParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionInvocationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionInvocationInput> {
    private static final SdkField<String> ACTION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroup").getter(FunctionInvocationInput.getter(FunctionInvocationInput::actionGroup)).setter(FunctionInvocationInput.setter(Builder::actionGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroup").build()}).build();
    private static final SdkField<String> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("function").getter(FunctionInvocationInput.getter(FunctionInvocationInput::function)).setter(FunctionInvocationInput.setter(Builder::function)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("function").build()}).build();
    private static final SdkField<List<FunctionParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(FunctionInvocationInput.getter(FunctionInvocationInput::parameters)).setter(FunctionInvocationInput.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FunctionParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_FIELD, FUNCTION_FIELD, PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionGroup;
    private final String function;
    private final List<FunctionParameter> parameters;

    private FunctionInvocationInput(BuilderImpl builder) {
        this.actionGroup = builder.actionGroup;
        this.function = builder.function;
        this.parameters = builder.parameters;
    }

    public final String actionGroup() {
        return this.actionGroup;
    }

    public final String function() {
        return this.function;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<FunctionParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.function());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionInvocationInput)) {
            return false;
        }
        FunctionInvocationInput other = (FunctionInvocationInput)obj;
        return Objects.equals(this.actionGroup(), other.actionGroup()) && Objects.equals(this.function(), other.function()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionInvocationInput").add("ActionGroup", (Object)this.actionGroup()).add("Function", (Object)this.function()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroup": {
                return Optional.ofNullable(clazz.cast(this.actionGroup()));
            }
            case "function": {
                return Optional.ofNullable(clazz.cast(this.function()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionInvocationInput, T> g) {
        return obj -> g.apply((FunctionInvocationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionGroup;
        private String function;
        private List<FunctionParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionInvocationInput model) {
            this.actionGroup(model.actionGroup);
            this.function(model.function);
            this.parameters(model.parameters);
        }

        public final String getActionGroup() {
            return this.actionGroup;
        }

        public final void setActionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
        }

        @Override
        public final Builder actionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
            return this;
        }

        public final String getFunction() {
            return this.function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final List<FunctionParameter.Builder> getParameters() {
            List<FunctionParameter.Builder> result = FunctionParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<FunctionParameter.BuilderImpl> parameters) {
            this.parameters = FunctionParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<FunctionParameter> parameters) {
            this.parameters = FunctionParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(FunctionParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<FunctionParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (FunctionParameter)((FunctionParameter.Builder)FunctionParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FunctionInvocationInput build() {
            return new FunctionInvocationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionInvocationInput> {
        public Builder actionGroup(String var1);

        public Builder function(String var1);

        public Builder parameters(Collection<FunctionParameter> var1);

        public Builder parameters(FunctionParameter ... var1);

        public Builder parameters(Consumer<FunctionParameter.Builder> ... var1);
    }
}

