/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.ActionInvocationType;
import software.amazon.awssdk.services.bedrockagentruntime.model.ApiParameter;
import software.amazon.awssdk.services.bedrockagentruntime.model.ApiParametersCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.ApiRequestBody;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiInvocationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiInvocationInput> {
    private static final SdkField<String> ACTION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroup").getter(ApiInvocationInput.getter(ApiInvocationInput::actionGroup)).setter(ApiInvocationInput.setter(Builder::actionGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroup").build()}).build();
    private static final SdkField<String> ACTION_INVOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionInvocationType").getter(ApiInvocationInput.getter(ApiInvocationInput::actionInvocationTypeAsString)).setter(ApiInvocationInput.setter(Builder::actionInvocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionInvocationType").build()}).build();
    private static final SdkField<String> API_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiPath").getter(ApiInvocationInput.getter(ApiInvocationInput::apiPath)).setter(ApiInvocationInput.setter(Builder::apiPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiPath").build()}).build();
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpMethod").getter(ApiInvocationInput.getter(ApiInvocationInput::httpMethod)).setter(ApiInvocationInput.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpMethod").build()}).build();
    private static final SdkField<List<ApiParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(ApiInvocationInput.getter(ApiInvocationInput::parameters)).setter(ApiInvocationInput.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApiParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApiRequestBody> REQUEST_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("requestBody").getter(ApiInvocationInput.getter(ApiInvocationInput::requestBody)).setter(ApiInvocationInput.setter(Builder::requestBody)).constructor(ApiRequestBody::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestBody").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_FIELD, ACTION_INVOCATION_TYPE_FIELD, API_PATH_FIELD, HTTP_METHOD_FIELD, PARAMETERS_FIELD, REQUEST_BODY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actionGroup", ACTION_GROUP_FIELD);
            this.put("actionInvocationType", ACTION_INVOCATION_TYPE_FIELD);
            this.put("apiPath", API_PATH_FIELD);
            this.put("httpMethod", HTTP_METHOD_FIELD);
            this.put("parameters", PARAMETERS_FIELD);
            this.put("requestBody", REQUEST_BODY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String actionGroup;
    private final String actionInvocationType;
    private final String apiPath;
    private final String httpMethod;
    private final List<ApiParameter> parameters;
    private final ApiRequestBody requestBody;

    private ApiInvocationInput(BuilderImpl builder) {
        this.actionGroup = builder.actionGroup;
        this.actionInvocationType = builder.actionInvocationType;
        this.apiPath = builder.apiPath;
        this.httpMethod = builder.httpMethod;
        this.parameters = builder.parameters;
        this.requestBody = builder.requestBody;
    }

    public final String actionGroup() {
        return this.actionGroup;
    }

    public final ActionInvocationType actionInvocationType() {
        return ActionInvocationType.fromValue(this.actionInvocationType);
    }

    public final String actionInvocationTypeAsString() {
        return this.actionInvocationType;
    }

    public final String apiPath() {
        return this.apiPath;
    }

    public final String httpMethod() {
        return this.httpMethod;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<ApiParameter> parameters() {
        return this.parameters;
    }

    public final ApiRequestBody requestBody() {
        return this.requestBody;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionInvocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestBody());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiInvocationInput)) {
            return false;
        }
        ApiInvocationInput other = (ApiInvocationInput)obj;
        return Objects.equals(this.actionGroup(), other.actionGroup()) && Objects.equals(this.actionInvocationTypeAsString(), other.actionInvocationTypeAsString()) && Objects.equals(this.apiPath(), other.apiPath()) && Objects.equals(this.httpMethod(), other.httpMethod()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.requestBody(), other.requestBody());
    }

    public final String toString() {
        return ToString.builder((String)"ApiInvocationInput").add("ActionGroup", (Object)this.actionGroup()).add("ActionInvocationType", (Object)this.actionInvocationTypeAsString()).add("ApiPath", (Object)(this.apiPath() == null ? null : "*** Sensitive Data Redacted ***")).add("HttpMethod", (Object)this.httpMethod()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("RequestBody", (Object)this.requestBody()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroup": {
                return Optional.ofNullable(clazz.cast(this.actionGroup()));
            }
            case "actionInvocationType": {
                return Optional.ofNullable(clazz.cast(this.actionInvocationTypeAsString()));
            }
            case "apiPath": {
                return Optional.ofNullable(clazz.cast(this.apiPath()));
            }
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "requestBody": {
                return Optional.ofNullable(clazz.cast(this.requestBody()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ApiInvocationInput, T> g) {
        return obj -> g.apply((ApiInvocationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionGroup;
        private String actionInvocationType;
        private String apiPath;
        private String httpMethod;
        private List<ApiParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private ApiRequestBody requestBody;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiInvocationInput model) {
            this.actionGroup(model.actionGroup);
            this.actionInvocationType(model.actionInvocationType);
            this.apiPath(model.apiPath);
            this.httpMethod(model.httpMethod);
            this.parameters(model.parameters);
            this.requestBody(model.requestBody);
        }

        public final String getActionGroup() {
            return this.actionGroup;
        }

        public final void setActionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
        }

        @Override
        public final Builder actionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
            return this;
        }

        public final String getActionInvocationType() {
            return this.actionInvocationType;
        }

        public final void setActionInvocationType(String actionInvocationType) {
            this.actionInvocationType = actionInvocationType;
        }

        @Override
        public final Builder actionInvocationType(String actionInvocationType) {
            this.actionInvocationType = actionInvocationType;
            return this;
        }

        @Override
        public final Builder actionInvocationType(ActionInvocationType actionInvocationType) {
            this.actionInvocationType(actionInvocationType == null ? null : actionInvocationType.toString());
            return this;
        }

        public final String getApiPath() {
            return this.apiPath;
        }

        public final void setApiPath(String apiPath) {
            this.apiPath = apiPath;
        }

        @Override
        public final Builder apiPath(String apiPath) {
            this.apiPath = apiPath;
            return this;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final List<ApiParameter.Builder> getParameters() {
            List<ApiParameter.Builder> result = ApiParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ApiParameter.BuilderImpl> parameters) {
            this.parameters = ApiParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<ApiParameter> parameters) {
            this.parameters = ApiParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ApiParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ApiParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (ApiParameter)((ApiParameter.Builder)ApiParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ApiRequestBody.Builder getRequestBody() {
            return this.requestBody != null ? this.requestBody.toBuilder() : null;
        }

        public final void setRequestBody(ApiRequestBody.BuilderImpl requestBody) {
            this.requestBody = requestBody != null ? requestBody.build() : null;
        }

        @Override
        public final Builder requestBody(ApiRequestBody requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public ApiInvocationInput build() {
            return new ApiInvocationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiInvocationInput> {
        public Builder actionGroup(String var1);

        public Builder actionInvocationType(String var1);

        public Builder actionInvocationType(ActionInvocationType var1);

        public Builder apiPath(String var1);

        public Builder httpMethod(String var1);

        public Builder parameters(Collection<ApiParameter> var1);

        public Builder parameters(ApiParameter ... var1);

        public Builder parameters(Consumer<ApiParameter.Builder> ... var1);

        public Builder requestBody(ApiRequestBody var1);

        default public Builder requestBody(Consumer<ApiRequestBody.Builder> requestBody) {
            return this.requestBody((ApiRequestBody)((ApiRequestBody.Builder)ApiRequestBody.builder().applyMutation(requestBody)).build());
        }
    }
}

