/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.APISchema;
import software.amazon.awssdk.services.bedrockagentruntime.model.ActionGroupExecutor;
import software.amazon.awssdk.services.bedrockagentruntime.model.ActionGroupSignature;
import software.amazon.awssdk.services.bedrockagentruntime.model.FunctionSchema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentActionGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentActionGroup> {
    private static final SdkField<ActionGroupExecutor> ACTION_GROUP_EXECUTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionGroupExecutor").getter(AgentActionGroup.getter(AgentActionGroup::actionGroupExecutor)).setter(AgentActionGroup.setter(Builder::actionGroupExecutor)).constructor(ActionGroupExecutor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupExecutor").build()}).build();
    private static final SdkField<String> ACTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroupName").getter(AgentActionGroup.getter(AgentActionGroup::actionGroupName)).setter(AgentActionGroup.setter(Builder::actionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupName").build()}).build();
    private static final SdkField<APISchema> API_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("apiSchema").getter(AgentActionGroup.getter(AgentActionGroup::apiSchema)).setter(AgentActionGroup.setter(Builder::apiSchema)).constructor(APISchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSchema").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AgentActionGroup.getter(AgentActionGroup::description)).setter(AgentActionGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<FunctionSchema> FUNCTION_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("functionSchema").getter(AgentActionGroup.getter(AgentActionGroup::functionSchema)).setter(AgentActionGroup.setter(Builder::functionSchema)).constructor(FunctionSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionSchema").build()}).build();
    private static final SdkField<String> PARENT_ACTION_GROUP_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentActionGroupSignature").getter(AgentActionGroup.getter(AgentActionGroup::parentActionGroupSignatureAsString)).setter(AgentActionGroup.setter(Builder::parentActionGroupSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentActionGroupSignature").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_EXECUTOR_FIELD, ACTION_GROUP_NAME_FIELD, API_SCHEMA_FIELD, DESCRIPTION_FIELD, FUNCTION_SCHEMA_FIELD, PARENT_ACTION_GROUP_SIGNATURE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AgentActionGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ActionGroupExecutor actionGroupExecutor;
    private final String actionGroupName;
    private final APISchema apiSchema;
    private final String description;
    private final FunctionSchema functionSchema;
    private final String parentActionGroupSignature;

    private AgentActionGroup(BuilderImpl builder) {
        this.actionGroupExecutor = builder.actionGroupExecutor;
        this.actionGroupName = builder.actionGroupName;
        this.apiSchema = builder.apiSchema;
        this.description = builder.description;
        this.functionSchema = builder.functionSchema;
        this.parentActionGroupSignature = builder.parentActionGroupSignature;
    }

    public final ActionGroupExecutor actionGroupExecutor() {
        return this.actionGroupExecutor;
    }

    public final String actionGroupName() {
        return this.actionGroupName;
    }

    public final APISchema apiSchema() {
        return this.apiSchema;
    }

    public final String description() {
        return this.description;
    }

    public final FunctionSchema functionSchema() {
        return this.functionSchema;
    }

    public final ActionGroupSignature parentActionGroupSignature() {
        return ActionGroupSignature.fromValue(this.parentActionGroupSignature);
    }

    public final String parentActionGroupSignatureAsString() {
        return this.parentActionGroupSignature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupExecutor());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentActionGroupSignatureAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentActionGroup)) {
            return false;
        }
        AgentActionGroup other = (AgentActionGroup)obj;
        return Objects.equals(this.actionGroupExecutor(), other.actionGroupExecutor()) && Objects.equals(this.actionGroupName(), other.actionGroupName()) && Objects.equals(this.apiSchema(), other.apiSchema()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.functionSchema(), other.functionSchema()) && Objects.equals(this.parentActionGroupSignatureAsString(), other.parentActionGroupSignatureAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AgentActionGroup").add("ActionGroupExecutor", (Object)this.actionGroupExecutor()).add("ActionGroupName", (Object)(this.actionGroupName() == null ? null : "*** Sensitive Data Redacted ***")).add("ApiSchema", (Object)this.apiSchema()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("FunctionSchema", (Object)this.functionSchema()).add("ParentActionGroupSignature", (Object)this.parentActionGroupSignatureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroupExecutor": {
                return Optional.ofNullable(clazz.cast(this.actionGroupExecutor()));
            }
            case "actionGroupName": {
                return Optional.ofNullable(clazz.cast(this.actionGroupName()));
            }
            case "apiSchema": {
                return Optional.ofNullable(clazz.cast(this.apiSchema()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "functionSchema": {
                return Optional.ofNullable(clazz.cast(this.functionSchema()));
            }
            case "parentActionGroupSignature": {
                return Optional.ofNullable(clazz.cast(this.parentActionGroupSignatureAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionGroupExecutor", ACTION_GROUP_EXECUTOR_FIELD);
        map.put("actionGroupName", ACTION_GROUP_NAME_FIELD);
        map.put("apiSchema", API_SCHEMA_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("functionSchema", FUNCTION_SCHEMA_FIELD);
        map.put("parentActionGroupSignature", PARENT_ACTION_GROUP_SIGNATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentActionGroup, T> g) {
        return obj -> g.apply((AgentActionGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActionGroupExecutor actionGroupExecutor;
        private String actionGroupName;
        private APISchema apiSchema;
        private String description;
        private FunctionSchema functionSchema;
        private String parentActionGroupSignature;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentActionGroup model) {
            this.actionGroupExecutor(model.actionGroupExecutor);
            this.actionGroupName(model.actionGroupName);
            this.apiSchema(model.apiSchema);
            this.description(model.description);
            this.functionSchema(model.functionSchema);
            this.parentActionGroupSignature(model.parentActionGroupSignature);
        }

        public final ActionGroupExecutor.Builder getActionGroupExecutor() {
            return this.actionGroupExecutor != null ? this.actionGroupExecutor.toBuilder() : null;
        }

        public final void setActionGroupExecutor(ActionGroupExecutor.BuilderImpl actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor != null ? actionGroupExecutor.build() : null;
        }

        @Override
        public final Builder actionGroupExecutor(ActionGroupExecutor actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor;
            return this;
        }

        public final String getActionGroupName() {
            return this.actionGroupName;
        }

        public final void setActionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
        }

        @Override
        public final Builder actionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
            return this;
        }

        public final APISchema.Builder getApiSchema() {
            return this.apiSchema != null ? this.apiSchema.toBuilder() : null;
        }

        public final void setApiSchema(APISchema.BuilderImpl apiSchema) {
            this.apiSchema = apiSchema != null ? apiSchema.build() : null;
        }

        @Override
        public final Builder apiSchema(APISchema apiSchema) {
            this.apiSchema = apiSchema;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final FunctionSchema.Builder getFunctionSchema() {
            return this.functionSchema != null ? this.functionSchema.toBuilder() : null;
        }

        public final void setFunctionSchema(FunctionSchema.BuilderImpl functionSchema) {
            this.functionSchema = functionSchema != null ? functionSchema.build() : null;
        }

        @Override
        public final Builder functionSchema(FunctionSchema functionSchema) {
            this.functionSchema = functionSchema;
            return this;
        }

        public final String getParentActionGroupSignature() {
            return this.parentActionGroupSignature;
        }

        public final void setParentActionGroupSignature(String parentActionGroupSignature) {
            this.parentActionGroupSignature = parentActionGroupSignature;
        }

        @Override
        public final Builder parentActionGroupSignature(String parentActionGroupSignature) {
            this.parentActionGroupSignature = parentActionGroupSignature;
            return this;
        }

        @Override
        public final Builder parentActionGroupSignature(ActionGroupSignature parentActionGroupSignature) {
            this.parentActionGroupSignature(parentActionGroupSignature == null ? null : parentActionGroupSignature.toString());
            return this;
        }

        public AgentActionGroup build() {
            return new AgentActionGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentActionGroup> {
        public Builder actionGroupExecutor(ActionGroupExecutor var1);

        default public Builder actionGroupExecutor(Consumer<ActionGroupExecutor.Builder> actionGroupExecutor) {
            return this.actionGroupExecutor((ActionGroupExecutor)((ActionGroupExecutor.Builder)ActionGroupExecutor.builder().applyMutation(actionGroupExecutor)).build());
        }

        public Builder actionGroupName(String var1);

        public Builder apiSchema(APISchema var1);

        default public Builder apiSchema(Consumer<APISchema.Builder> apiSchema) {
            return this.apiSchema((APISchema)((APISchema.Builder)APISchema.builder().applyMutation(apiSchema)).build());
        }

        public Builder description(String var1);

        public Builder functionSchema(FunctionSchema var1);

        default public Builder functionSchema(Consumer<FunctionSchema.Builder> functionSchema) {
            return this.functionSchema((FunctionSchema)((FunctionSchema.Builder)FunctionSchema.builder().applyMutation(functionSchema)).build());
        }

        public Builder parentActionGroupSignature(String var1);

        public Builder parentActionGroupSignature(ActionGroupSignature var1);
    }
}

