/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.Citation;
import software.amazon.awssdk.services.bedrockagentruntime.model.CitationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Attribution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Attribution> {
    private static final SdkField<List<Citation>> CITATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("citations").getter(Attribution.getter(Attribution::citations)).setter(Attribution.setter(Builder::citations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Citation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Attribution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Citation> citations;

    private Attribution(BuilderImpl builder) {
        this.citations = builder.citations;
    }

    public final boolean hasCitations() {
        return this.citations != null && !(this.citations instanceof SdkAutoConstructList);
    }

    public final List<Citation> citations() {
        return this.citations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCitations() ? this.citations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attribution)) {
            return false;
        }
        Attribution other = (Attribution)obj;
        return this.hasCitations() == other.hasCitations() && Objects.equals(this.citations(), other.citations());
    }

    public final String toString() {
        return ToString.builder((String)"Attribution").add("Citations", this.hasCitations() ? this.citations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "citations": {
                return Optional.ofNullable(clazz.cast(this.citations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Citation>>> map = new HashMap<String, SdkField<List<Citation>>>();
        map.put("citations", CITATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Attribution, T> g) {
        return obj -> g.apply((Attribution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Citation> citations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Attribution model) {
            this.citations(model.citations);
        }

        public final List<Citation.Builder> getCitations() {
            List<Citation.Builder> result = CitationsCopier.copyToBuilder(this.citations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCitations(Collection<Citation.BuilderImpl> citations) {
            this.citations = CitationsCopier.copyFromBuilder(citations);
        }

        @Override
        public final Builder citations(Collection<Citation> citations) {
            this.citations = CitationsCopier.copy(citations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Citation ... citations) {
            this.citations(Arrays.asList(citations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Consumer<Citation.Builder> ... citations) {
            this.citations(Stream.of(citations).map(c -> (Citation)((Citation.Builder)Citation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Attribution build() {
            return new Attribution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Attribution> {
        public Builder citations(Collection<Citation> var1);

        public Builder citations(Citation ... var1);

        public Builder citations(Consumer<Citation.Builder> ... var1);
    }
}

