/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkidentity.model.ChimeSdkIdentityResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ExpirationSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAppInstanceUserExpirationSettingsResponse
extends ChimeSdkIdentityResponse
implements ToCopyableBuilder<Builder, PutAppInstanceUserExpirationSettingsResponse> {
    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceUserArn").getter(PutAppInstanceUserExpirationSettingsResponse.getter(PutAppInstanceUserExpirationSettingsResponse::appInstanceUserArn)).setter(PutAppInstanceUserExpirationSettingsResponse.setter(Builder::appInstanceUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceUserArn").build()}).build();
    private static final SdkField<ExpirationSettings> EXPIRATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExpirationSettings").getter(PutAppInstanceUserExpirationSettingsResponse.getter(PutAppInstanceUserExpirationSettingsResponse::expirationSettings)).setter(PutAppInstanceUserExpirationSettingsResponse.setter(Builder::expirationSettings)).constructor(ExpirationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_USER_ARN_FIELD, EXPIRATION_SETTINGS_FIELD));
    private final String appInstanceUserArn;
    private final ExpirationSettings expirationSettings;

    private PutAppInstanceUserExpirationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.expirationSettings = builder.expirationSettings;
    }

    public final String appInstanceUserArn() {
        return this.appInstanceUserArn;
    }

    public final ExpirationSettings expirationSettings() {
        return this.expirationSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAppInstanceUserExpirationSettingsResponse)) {
            return false;
        }
        PutAppInstanceUserExpirationSettingsResponse other = (PutAppInstanceUserExpirationSettingsResponse)((Object)obj);
        return Objects.equals(this.appInstanceUserArn(), other.appInstanceUserArn()) && Objects.equals(this.expirationSettings(), other.expirationSettings());
    }

    public final String toString() {
        return ToString.builder((String)"PutAppInstanceUserExpirationSettingsResponse").add("AppInstanceUserArn", (Object)this.appInstanceUserArn()).add("ExpirationSettings", (Object)this.expirationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceUserArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceUserArn()));
            }
            case "ExpirationSettings": {
                return Optional.ofNullable(clazz.cast(this.expirationSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAppInstanceUserExpirationSettingsResponse, T> g) {
        return obj -> g.apply((PutAppInstanceUserExpirationSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkIdentityResponse.BuilderImpl
    implements Builder {
        private String appInstanceUserArn;
        private ExpirationSettings expirationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAppInstanceUserExpirationSettingsResponse model) {
            super(model);
            this.appInstanceUserArn(model.appInstanceUserArn);
            this.expirationSettings(model.expirationSettings);
        }

        public final String getAppInstanceUserArn() {
            return this.appInstanceUserArn;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final ExpirationSettings.Builder getExpirationSettings() {
            return this.expirationSettings != null ? this.expirationSettings.toBuilder() : null;
        }

        public final void setExpirationSettings(ExpirationSettings.BuilderImpl expirationSettings) {
            this.expirationSettings = expirationSettings != null ? expirationSettings.build() : null;
        }

        @Override
        public final Builder expirationSettings(ExpirationSettings expirationSettings) {
            this.expirationSettings = expirationSettings;
            return this;
        }

        @Override
        public PutAppInstanceUserExpirationSettingsResponse build() {
            return new PutAppInstanceUserExpirationSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkIdentityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAppInstanceUserExpirationSettingsResponse> {
        public Builder appInstanceUserArn(String var1);

        public Builder expirationSettings(ExpirationSettings var1);

        default public Builder expirationSettings(Consumer<ExpirationSettings.Builder> expirationSettings) {
            return this.expirationSettings((ExpirationSettings)((ExpirationSettings.Builder)ExpirationSettings.builder().applyMutation(expirationSettings)).build());
        }
    }
}

