/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedInstancesPricing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedInstancesPricing> {
    private static final SdkField<Double> ESTIMATED_ON_DEMAND_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedOnDemandCost").getter(ReservedInstancesPricing.getter(ReservedInstancesPricing::estimatedOnDemandCost)).setter(ReservedInstancesPricing.setter(Builder::estimatedOnDemandCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedOnDemandCost").build()}).build();
    private static final SdkField<Double> MONTHLY_RESERVATION_ELIGIBLE_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("monthlyReservationEligibleCost").getter(ReservedInstancesPricing.getter(ReservedInstancesPricing::monthlyReservationEligibleCost)).setter(ReservedInstancesPricing.setter(Builder::monthlyReservationEligibleCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlyReservationEligibleCost").build()}).build();
    private static final SdkField<Double> SAVINGS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("savingsPercentage").getter(ReservedInstancesPricing.getter(ReservedInstancesPricing::savingsPercentage)).setter(ReservedInstancesPricing.setter(Builder::savingsPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPercentage").build()}).build();
    private static final SdkField<Double> ESTIMATED_MONTHLY_AMORTIZED_RESERVATION_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedMonthlyAmortizedReservationCost").getter(ReservedInstancesPricing.getter(ReservedInstancesPricing::estimatedMonthlyAmortizedReservationCost)).setter(ReservedInstancesPricing.setter(Builder::estimatedMonthlyAmortizedReservationCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlyAmortizedReservationCost").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTIMATED_ON_DEMAND_COST_FIELD, MONTHLY_RESERVATION_ELIGIBLE_COST_FIELD, SAVINGS_PERCENTAGE_FIELD, ESTIMATED_MONTHLY_AMORTIZED_RESERVATION_COST_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double estimatedOnDemandCost;
    private final Double monthlyReservationEligibleCost;
    private final Double savingsPercentage;
    private final Double estimatedMonthlyAmortizedReservationCost;

    private ReservedInstancesPricing(BuilderImpl builder) {
        this.estimatedOnDemandCost = builder.estimatedOnDemandCost;
        this.monthlyReservationEligibleCost = builder.monthlyReservationEligibleCost;
        this.savingsPercentage = builder.savingsPercentage;
        this.estimatedMonthlyAmortizedReservationCost = builder.estimatedMonthlyAmortizedReservationCost;
    }

    public final Double estimatedOnDemandCost() {
        return this.estimatedOnDemandCost;
    }

    public final Double monthlyReservationEligibleCost() {
        return this.monthlyReservationEligibleCost;
    }

    public final Double savingsPercentage() {
        return this.savingsPercentage;
    }

    public final Double estimatedMonthlyAmortizedReservationCost() {
        return this.estimatedMonthlyAmortizedReservationCost;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedOnDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.monthlyReservationEligibleCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlyAmortizedReservationCost());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesPricing)) {
            return false;
        }
        ReservedInstancesPricing other = (ReservedInstancesPricing)obj;
        return Objects.equals(this.estimatedOnDemandCost(), other.estimatedOnDemandCost()) && Objects.equals(this.monthlyReservationEligibleCost(), other.monthlyReservationEligibleCost()) && Objects.equals(this.savingsPercentage(), other.savingsPercentage()) && Objects.equals(this.estimatedMonthlyAmortizedReservationCost(), other.estimatedMonthlyAmortizedReservationCost());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedInstancesPricing").add("EstimatedOnDemandCost", (Object)this.estimatedOnDemandCost()).add("MonthlyReservationEligibleCost", (Object)this.monthlyReservationEligibleCost()).add("SavingsPercentage", (Object)this.savingsPercentage()).add("EstimatedMonthlyAmortizedReservationCost", (Object)this.estimatedMonthlyAmortizedReservationCost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "estimatedOnDemandCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedOnDemandCost()));
            }
            case "monthlyReservationEligibleCost": {
                return Optional.ofNullable(clazz.cast(this.monthlyReservationEligibleCost()));
            }
            case "savingsPercentage": {
                return Optional.ofNullable(clazz.cast(this.savingsPercentage()));
            }
            case "estimatedMonthlyAmortizedReservationCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlyAmortizedReservationCost()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesPricing, T> g) {
        return obj -> g.apply((ReservedInstancesPricing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double estimatedOnDemandCost;
        private Double monthlyReservationEligibleCost;
        private Double savingsPercentage;
        private Double estimatedMonthlyAmortizedReservationCost;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesPricing model) {
            this.estimatedOnDemandCost(model.estimatedOnDemandCost);
            this.monthlyReservationEligibleCost(model.monthlyReservationEligibleCost);
            this.savingsPercentage(model.savingsPercentage);
            this.estimatedMonthlyAmortizedReservationCost(model.estimatedMonthlyAmortizedReservationCost);
        }

        public final Double getEstimatedOnDemandCost() {
            return this.estimatedOnDemandCost;
        }

        public final void setEstimatedOnDemandCost(Double estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
        }

        @Override
        public final Builder estimatedOnDemandCost(Double estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
            return this;
        }

        public final Double getMonthlyReservationEligibleCost() {
            return this.monthlyReservationEligibleCost;
        }

        public final void setMonthlyReservationEligibleCost(Double monthlyReservationEligibleCost) {
            this.monthlyReservationEligibleCost = monthlyReservationEligibleCost;
        }

        @Override
        public final Builder monthlyReservationEligibleCost(Double monthlyReservationEligibleCost) {
            this.monthlyReservationEligibleCost = monthlyReservationEligibleCost;
            return this;
        }

        public final Double getSavingsPercentage() {
            return this.savingsPercentage;
        }

        public final void setSavingsPercentage(Double savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
        }

        @Override
        public final Builder savingsPercentage(Double savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
            return this;
        }

        public final Double getEstimatedMonthlyAmortizedReservationCost() {
            return this.estimatedMonthlyAmortizedReservationCost;
        }

        public final void setEstimatedMonthlyAmortizedReservationCost(Double estimatedMonthlyAmortizedReservationCost) {
            this.estimatedMonthlyAmortizedReservationCost = estimatedMonthlyAmortizedReservationCost;
        }

        @Override
        public final Builder estimatedMonthlyAmortizedReservationCost(Double estimatedMonthlyAmortizedReservationCost) {
            this.estimatedMonthlyAmortizedReservationCost = estimatedMonthlyAmortizedReservationCost;
            return this;
        }

        public ReservedInstancesPricing build() {
            return new ReservedInstancesPricing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedInstancesPricing> {
        public Builder estimatedOnDemandCost(Double var1);

        public Builder monthlyReservationEligibleCost(Double var1);

        public Builder savingsPercentage(Double var1);

        public Builder estimatedMonthlyAmortizedReservationCost(Double var1);
    }
}

