/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costoptimizationhub.CostOptimizationHubClient;
import software.amazon.awssdk.services.costoptimizationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.Recommendation;

public class ListRecommendationsIterable
implements SdkIterable<ListRecommendationsResponse> {
    private final CostOptimizationHubClient client;
    private final ListRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommendationsIterable(CostOptimizationHubClient client, ListRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecommendationsResponseFetcher();
    }

    public Iterator<ListRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Recommendation> items() {
        Function<ListRecommendationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecommendationsResponseFetcher
    implements SyncPageFetcher<ListRecommendationsResponse> {
        private ListRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecommendationsResponse nextPage(ListRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationsIterable.this.client.listRecommendations(ListRecommendationsIterable.this.firstRequest);
            }
            return ListRecommendationsIterable.this.client.listRecommendations((ListRecommendationsRequest)((Object)ListRecommendationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

