/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costoptimizationhub.CostOptimizationHubClient;
import software.amazon.awssdk.services.costoptimizationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.RecommendationSummary;

public class ListRecommendationSummariesIterable
implements SdkIterable<ListRecommendationSummariesResponse> {
    private final CostOptimizationHubClient client;
    private final ListRecommendationSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommendationSummariesIterable(CostOptimizationHubClient client, ListRecommendationSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecommendationSummariesResponseFetcher();
    }

    public Iterator<ListRecommendationSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecommendationSummary> items() {
        Function<ListRecommendationSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecommendationSummariesResponseFetcher
    implements SyncPageFetcher<ListRecommendationSummariesResponse> {
        private ListRecommendationSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecommendationSummariesResponse nextPage(ListRecommendationSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationSummariesIterable.this.client.listRecommendationSummaries(ListRecommendationSummariesIterable.this.firstRequest);
            }
            return ListRecommendationSummariesIterable.this.client.listRecommendationSummaries((ListRecommendationSummariesRequest)((Object)ListRecommendationSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

