/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AllocationStrategy {
    PRIORITIZED("Prioritized"),
    LOWEST_PRICE("LowestPrice"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AllocationStrategy> VALUE_MAP;
    private final String value;

    private AllocationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AllocationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AllocationStrategy> knownValues() {
        EnumSet<AllocationStrategy> knownValues = EnumSet.allOf(AllocationStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AllocationStrategy.class, AllocationStrategy::toString);
    }
}

