/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.DataFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSegmentSnapshotRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, CreateSegmentSnapshotRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateSegmentSnapshotRequest.getter(CreateSegmentSnapshotRequest::domainName)).setter(CreateSegmentSnapshotRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> SEGMENT_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentDefinitionName").getter(CreateSegmentSnapshotRequest.getter(CreateSegmentSnapshotRequest::segmentDefinitionName)).setter(CreateSegmentSnapshotRequest.setter(Builder::segmentDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("SegmentDefinitionName").build()}).build();
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(CreateSegmentSnapshotRequest.getter(CreateSegmentSnapshotRequest::dataFormatAsString)).setter(CreateSegmentSnapshotRequest.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKey").getter(CreateSegmentSnapshotRequest.getter(CreateSegmentSnapshotRequest::encryptionKey)).setter(CreateSegmentSnapshotRequest.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateSegmentSnapshotRequest.getter(CreateSegmentSnapshotRequest::roleArn)).setter(CreateSegmentSnapshotRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> DESTINATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationUri").getter(CreateSegmentSnapshotRequest.getter(CreateSegmentSnapshotRequest::destinationUri)).setter(CreateSegmentSnapshotRequest.setter(Builder::destinationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, SEGMENT_DEFINITION_NAME_FIELD, DATA_FORMAT_FIELD, ENCRYPTION_KEY_FIELD, ROLE_ARN_FIELD, DESTINATION_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("SegmentDefinitionName", SEGMENT_DEFINITION_NAME_FIELD);
            this.put("DataFormat", DATA_FORMAT_FIELD);
            this.put("EncryptionKey", ENCRYPTION_KEY_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("DestinationUri", DESTINATION_URI_FIELD);
        }
    });
    private final String domainName;
    private final String segmentDefinitionName;
    private final String dataFormat;
    private final String encryptionKey;
    private final String roleArn;
    private final String destinationUri;

    private CreateSegmentSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.segmentDefinitionName = builder.segmentDefinitionName;
        this.dataFormat = builder.dataFormat;
        this.encryptionKey = builder.encryptionKey;
        this.roleArn = builder.roleArn;
        this.destinationUri = builder.destinationUri;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String segmentDefinitionName() {
        return this.segmentDefinitionName;
    }

    public final DataFormat dataFormat() {
        return DataFormat.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String destinationUri() {
        return this.destinationUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSegmentSnapshotRequest)) {
            return false;
        }
        CreateSegmentSnapshotRequest other = (CreateSegmentSnapshotRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.segmentDefinitionName(), other.segmentDefinitionName()) && Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.destinationUri(), other.destinationUri());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSegmentSnapshotRequest").add("DomainName", (Object)this.domainName()).add("SegmentDefinitionName", (Object)this.segmentDefinitionName()).add("DataFormat", (Object)this.dataFormatAsString()).add("EncryptionKey", (Object)this.encryptionKey()).add("RoleArn", (Object)this.roleArn()).add("DestinationUri", (Object)this.destinationUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "SegmentDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.segmentDefinitionName()));
            }
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "EncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "DestinationUri": {
                return Optional.ofNullable(clazz.cast(this.destinationUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSegmentSnapshotRequest, T> g) {
        return obj -> g.apply((CreateSegmentSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String segmentDefinitionName;
        private String dataFormat;
        private String encryptionKey;
        private String roleArn;
        private String destinationUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSegmentSnapshotRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.segmentDefinitionName(model.segmentDefinitionName);
            this.dataFormat(model.dataFormat);
            this.encryptionKey(model.encryptionKey);
            this.roleArn(model.roleArn);
            this.destinationUri(model.destinationUri);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getSegmentDefinitionName() {
            return this.segmentDefinitionName;
        }

        public final void setSegmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
        }

        @Override
        public final Builder segmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
            return this;
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDestinationUri() {
            return this.destinationUri;
        }

        public final void setDestinationUri(String destinationUri) {
            this.destinationUri = destinationUri;
        }

        @Override
        public final Builder destinationUri(String destinationUri) {
            this.destinationUri = destinationUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSegmentSnapshotRequest build() {
            return new CreateSegmentSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSegmentSnapshotRequest> {
        public Builder domainName(String var1);

        public Builder segmentDefinitionName(String var1);

        public Builder dataFormat(String var1);

        public Builder dataFormat(DataFormat var1);

        public Builder encryptionKey(String var1);

        public Builder roleArn(String var1);

        public Builder destinationUri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

