/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.AutoMerging;
import software.amazon.awssdk.services.customerprofiles.model.ExportingConfig;
import software.amazon.awssdk.services.customerprofiles.model.JobSchedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchingRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatchingRequest> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(MatchingRequest.getter(MatchingRequest::enabled)).setter(MatchingRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<JobSchedule> JOB_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobSchedule").getter(MatchingRequest.getter(MatchingRequest::jobSchedule)).setter(MatchingRequest.setter(Builder::jobSchedule)).constructor(JobSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSchedule").build()}).build();
    private static final SdkField<AutoMerging> AUTO_MERGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMerging").getter(MatchingRequest.getter(MatchingRequest::autoMerging)).setter(MatchingRequest.setter(Builder::autoMerging)).constructor(AutoMerging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMerging").build()}).build();
    private static final SdkField<ExportingConfig> EXPORTING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportingConfig").getter(MatchingRequest.getter(MatchingRequest::exportingConfig)).setter(MatchingRequest.setter(Builder::exportingConfig)).constructor(ExportingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, JOB_SCHEDULE_FIELD, AUTO_MERGING_FIELD, EXPORTING_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Enabled", ENABLED_FIELD);
            this.put("JobSchedule", JOB_SCHEDULE_FIELD);
            this.put("AutoMerging", AUTO_MERGING_FIELD);
            this.put("ExportingConfig", EXPORTING_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final JobSchedule jobSchedule;
    private final AutoMerging autoMerging;
    private final ExportingConfig exportingConfig;

    private MatchingRequest(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.jobSchedule = builder.jobSchedule;
        this.autoMerging = builder.autoMerging;
        this.exportingConfig = builder.exportingConfig;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final JobSchedule jobSchedule() {
        return this.jobSchedule;
    }

    public final AutoMerging autoMerging() {
        return this.autoMerging;
    }

    public final ExportingConfig exportingConfig() {
        return this.exportingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMerging());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchingRequest)) {
            return false;
        }
        MatchingRequest other = (MatchingRequest)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.jobSchedule(), other.jobSchedule()) && Objects.equals(this.autoMerging(), other.autoMerging()) && Objects.equals(this.exportingConfig(), other.exportingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"MatchingRequest").add("Enabled", (Object)this.enabled()).add("JobSchedule", (Object)this.jobSchedule()).add("AutoMerging", (Object)this.autoMerging()).add("ExportingConfig", (Object)this.exportingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "JobSchedule": {
                return Optional.ofNullable(clazz.cast(this.jobSchedule()));
            }
            case "AutoMerging": {
                return Optional.ofNullable(clazz.cast(this.autoMerging()));
            }
            case "ExportingConfig": {
                return Optional.ofNullable(clazz.cast(this.exportingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MatchingRequest, T> g) {
        return obj -> g.apply((MatchingRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private JobSchedule jobSchedule;
        private AutoMerging autoMerging;
        private ExportingConfig exportingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchingRequest model) {
            this.enabled(model.enabled);
            this.jobSchedule(model.jobSchedule);
            this.autoMerging(model.autoMerging);
            this.exportingConfig(model.exportingConfig);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final JobSchedule.Builder getJobSchedule() {
            return this.jobSchedule != null ? this.jobSchedule.toBuilder() : null;
        }

        public final void setJobSchedule(JobSchedule.BuilderImpl jobSchedule) {
            this.jobSchedule = jobSchedule != null ? jobSchedule.build() : null;
        }

        @Override
        public final Builder jobSchedule(JobSchedule jobSchedule) {
            this.jobSchedule = jobSchedule;
            return this;
        }

        public final AutoMerging.Builder getAutoMerging() {
            return this.autoMerging != null ? this.autoMerging.toBuilder() : null;
        }

        public final void setAutoMerging(AutoMerging.BuilderImpl autoMerging) {
            this.autoMerging = autoMerging != null ? autoMerging.build() : null;
        }

        @Override
        public final Builder autoMerging(AutoMerging autoMerging) {
            this.autoMerging = autoMerging;
            return this;
        }

        public final ExportingConfig.Builder getExportingConfig() {
            return this.exportingConfig != null ? this.exportingConfig.toBuilder() : null;
        }

        public final void setExportingConfig(ExportingConfig.BuilderImpl exportingConfig) {
            this.exportingConfig = exportingConfig != null ? exportingConfig.build() : null;
        }

        @Override
        public final Builder exportingConfig(ExportingConfig exportingConfig) {
            this.exportingConfig = exportingConfig;
            return this;
        }

        public MatchingRequest build() {
            return new MatchingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatchingRequest> {
        public Builder enabled(Boolean var1);

        public Builder jobSchedule(JobSchedule var1);

        default public Builder jobSchedule(Consumer<JobSchedule.Builder> jobSchedule) {
            return this.jobSchedule((JobSchedule)((JobSchedule.Builder)JobSchedule.builder().applyMutation(jobSchedule)).build());
        }

        public Builder autoMerging(AutoMerging var1);

        default public Builder autoMerging(Consumer<AutoMerging.Builder> autoMerging) {
            return this.autoMerging((AutoMerging)((AutoMerging.Builder)AutoMerging.builder().applyMutation(autoMerging)).build());
        }

        public Builder exportingConfig(ExportingConfig var1);

        default public Builder exportingConfig(Consumer<ExportingConfig.Builder> exportingConfig) {
            return this.exportingConfig((ExportingConfig)((ExportingConfig.Builder)ExportingConfig.builder().applyMutation(exportingConfig)).build());
        }
    }
}

