/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributeItem;
import software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesResponse;

public class ListObjectTypeAttributesIterable
implements SdkIterable<ListObjectTypeAttributesResponse> {
    private final CustomerProfilesClient client;
    private final ListObjectTypeAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListObjectTypeAttributesIterable(CustomerProfilesClient client, ListObjectTypeAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListObjectTypeAttributesResponseFetcher();
    }

    public Iterator<ListObjectTypeAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListObjectTypeAttributeItem> items() {
        Function<ListObjectTypeAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListObjectTypeAttributesResponseFetcher
    implements SyncPageFetcher<ListObjectTypeAttributesResponse> {
        private ListObjectTypeAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectTypeAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListObjectTypeAttributesResponse nextPage(ListObjectTypeAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectTypeAttributesIterable.this.client.listObjectTypeAttributes(ListObjectTypeAttributesIterable.this.firstRequest);
            }
            return ListObjectTypeAttributesIterable.this.client.listObjectTypeAttributes((ListObjectTypeAttributesRequest)((Object)ListObjectTypeAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

