/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesAsyncClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsResponse;
import software.amazon.awssdk.services.customerprofiles.model.SegmentDefinitionItem;

public class ListSegmentDefinitionsPublisher
implements SdkPublisher<ListSegmentDefinitionsResponse> {
    private final CustomerProfilesAsyncClient client;
    private final ListSegmentDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSegmentDefinitionsPublisher(CustomerProfilesAsyncClient client, ListSegmentDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSegmentDefinitionsPublisher(CustomerProfilesAsyncClient client, ListSegmentDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSegmentDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSegmentDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SegmentDefinitionItem> items() {
        Function<ListSegmentDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSegmentDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSegmentDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListSegmentDefinitionsResponse> {
        private ListSegmentDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSegmentDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSegmentDefinitionsResponse> nextPage(ListSegmentDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListSegmentDefinitionsPublisher.this.client.listSegmentDefinitions(ListSegmentDefinitionsPublisher.this.firstRequest);
            }
            return ListSegmentDefinitionsPublisher.this.client.listSegmentDefinitions((ListSegmentDefinitionsRequest)((Object)ListSegmentDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

