/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.AssessmentReportType;
import software.amazon.awssdk.services.databasemigration.model.AssessmentReportTypesListCopier;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportMetadataModelAssessmentRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, ExportMetadataModelAssessmentRequest> {
    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectIdentifier").getter(ExportMetadataModelAssessmentRequest.getter(ExportMetadataModelAssessmentRequest::migrationProjectIdentifier)).setter(ExportMetadataModelAssessmentRequest.setter(Builder::migrationProjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build()}).build();
    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionRules").getter(ExportMetadataModelAssessmentRequest.getter(ExportMetadataModelAssessmentRequest::selectionRules)).setter(ExportMetadataModelAssessmentRequest.setter(Builder::selectionRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()}).build();
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileName").getter(ExportMetadataModelAssessmentRequest.getter(ExportMetadataModelAssessmentRequest::fileName)).setter(ExportMetadataModelAssessmentRequest.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()}).build();
    private static final SdkField<List<String>> ASSESSMENT_REPORT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssessmentReportTypes").getter(ExportMetadataModelAssessmentRequest.getter(ExportMetadataModelAssessmentRequest::assessmentReportTypesAsStrings)).setter(ExportMetadataModelAssessmentRequest.setter(Builder::assessmentReportTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentReportTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_PROJECT_IDENTIFIER_FIELD, SELECTION_RULES_FIELD, FILE_NAME_FIELD, ASSESSMENT_REPORT_TYPES_FIELD));
    private final String migrationProjectIdentifier;
    private final String selectionRules;
    private final String fileName;
    private final List<String> assessmentReportTypes;

    private ExportMetadataModelAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.selectionRules = builder.selectionRules;
        this.fileName = builder.fileName;
        this.assessmentReportTypes = builder.assessmentReportTypes;
    }

    public final String migrationProjectIdentifier() {
        return this.migrationProjectIdentifier;
    }

    public final String selectionRules() {
        return this.selectionRules;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final List<AssessmentReportType> assessmentReportTypes() {
        return AssessmentReportTypesListCopier.copyStringToEnum(this.assessmentReportTypes);
    }

    public final boolean hasAssessmentReportTypes() {
        return this.assessmentReportTypes != null && !(this.assessmentReportTypes instanceof SdkAutoConstructList);
    }

    public final List<String> assessmentReportTypesAsStrings() {
        return this.assessmentReportTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentReportTypes() ? this.assessmentReportTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportMetadataModelAssessmentRequest)) {
            return false;
        }
        ExportMetadataModelAssessmentRequest other = (ExportMetadataModelAssessmentRequest)((Object)obj);
        return Objects.equals(this.migrationProjectIdentifier(), other.migrationProjectIdentifier()) && Objects.equals(this.selectionRules(), other.selectionRules()) && Objects.equals(this.fileName(), other.fileName()) && this.hasAssessmentReportTypes() == other.hasAssessmentReportTypes() && Objects.equals(this.assessmentReportTypesAsStrings(), other.assessmentReportTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ExportMetadataModelAssessmentRequest").add("MigrationProjectIdentifier", (Object)this.migrationProjectIdentifier()).add("SelectionRules", (Object)this.selectionRules()).add("FileName", (Object)this.fileName()).add("AssessmentReportTypes", this.hasAssessmentReportTypes() ? this.assessmentReportTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MigrationProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectIdentifier()));
            }
            case "SelectionRules": {
                return Optional.ofNullable(clazz.cast(this.selectionRules()));
            }
            case "FileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "AssessmentReportTypes": {
                return Optional.ofNullable(clazz.cast(this.assessmentReportTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportMetadataModelAssessmentRequest, T> g) {
        return obj -> g.apply((ExportMetadataModelAssessmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String migrationProjectIdentifier;
        private String selectionRules;
        private String fileName;
        private List<String> assessmentReportTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportMetadataModelAssessmentRequest model) {
            super(model);
            this.migrationProjectIdentifier(model.migrationProjectIdentifier);
            this.selectionRules(model.selectionRules);
            this.fileName(model.fileName);
            this.assessmentReportTypesWithStrings(model.assessmentReportTypes);
        }

        public final String getMigrationProjectIdentifier() {
            return this.migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getSelectionRules() {
            return this.selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final Collection<String> getAssessmentReportTypes() {
            if (this.assessmentReportTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assessmentReportTypes;
        }

        public final void setAssessmentReportTypes(Collection<String> assessmentReportTypes) {
            this.assessmentReportTypes = AssessmentReportTypesListCopier.copy(assessmentReportTypes);
        }

        @Override
        public final Builder assessmentReportTypesWithStrings(Collection<String> assessmentReportTypes) {
            this.assessmentReportTypes = AssessmentReportTypesListCopier.copy(assessmentReportTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentReportTypesWithStrings(String ... assessmentReportTypes) {
            this.assessmentReportTypesWithStrings(Arrays.asList(assessmentReportTypes));
            return this;
        }

        @Override
        public final Builder assessmentReportTypes(Collection<AssessmentReportType> assessmentReportTypes) {
            this.assessmentReportTypes = AssessmentReportTypesListCopier.copyEnumToString(assessmentReportTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentReportTypes(AssessmentReportType ... assessmentReportTypes) {
            this.assessmentReportTypes(Arrays.asList(assessmentReportTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportMetadataModelAssessmentRequest build() {
            return new ExportMetadataModelAssessmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportMetadataModelAssessmentRequest> {
        public Builder migrationProjectIdentifier(String var1);

        public Builder selectionRules(String var1);

        public Builder fileName(String var1);

        public Builder assessmentReportTypesWithStrings(Collection<String> var1);

        public Builder assessmentReportTypesWithStrings(String ... var1);

        public Builder assessmentReportTypes(Collection<AssessmentReportType> var1);

        public Builder assessmentReportTypes(AssessmentReportType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

