/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationTaskStats
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationTaskStats> {
    private static final SdkField<Integer> FULL_LOAD_PROGRESS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FullLoadProgressPercent").getter(ReplicationTaskStats.getter(ReplicationTaskStats::fullLoadProgressPercent)).setter(ReplicationTaskStats.setter(Builder::fullLoadProgressPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadProgressPercent").build()}).build();
    private static final SdkField<Long> ELAPSED_TIME_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ElapsedTimeMillis").getter(ReplicationTaskStats.getter(ReplicationTaskStats::elapsedTimeMillis)).setter(ReplicationTaskStats.setter(Builder::elapsedTimeMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeMillis").build()}).build();
    private static final SdkField<Integer> TABLES_LOADED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TablesLoaded").getter(ReplicationTaskStats.getter(ReplicationTaskStats::tablesLoaded)).setter(ReplicationTaskStats.setter(Builder::tablesLoaded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesLoaded").build()}).build();
    private static final SdkField<Integer> TABLES_LOADING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TablesLoading").getter(ReplicationTaskStats.getter(ReplicationTaskStats::tablesLoading)).setter(ReplicationTaskStats.setter(Builder::tablesLoading)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesLoading").build()}).build();
    private static final SdkField<Integer> TABLES_QUEUED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TablesQueued").getter(ReplicationTaskStats.getter(ReplicationTaskStats::tablesQueued)).setter(ReplicationTaskStats.setter(Builder::tablesQueued)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesQueued").build()}).build();
    private static final SdkField<Integer> TABLES_ERRORED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TablesErrored").getter(ReplicationTaskStats.getter(ReplicationTaskStats::tablesErrored)).setter(ReplicationTaskStats.setter(Builder::tablesErrored)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesErrored").build()}).build();
    private static final SdkField<Instant> FRESH_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FreshStartDate").getter(ReplicationTaskStats.getter(ReplicationTaskStats::freshStartDate)).setter(ReplicationTaskStats.setter(Builder::freshStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FreshStartDate").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(ReplicationTaskStats.getter(ReplicationTaskStats::startDate)).setter(ReplicationTaskStats.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> STOP_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StopDate").getter(ReplicationTaskStats.getter(ReplicationTaskStats::stopDate)).setter(ReplicationTaskStats.setter(Builder::stopDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopDate").build()}).build();
    private static final SdkField<Instant> FULL_LOAD_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FullLoadStartDate").getter(ReplicationTaskStats.getter(ReplicationTaskStats::fullLoadStartDate)).setter(ReplicationTaskStats.setter(Builder::fullLoadStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadStartDate").build()}).build();
    private static final SdkField<Instant> FULL_LOAD_FINISH_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FullLoadFinishDate").getter(ReplicationTaskStats.getter(ReplicationTaskStats::fullLoadFinishDate)).setter(ReplicationTaskStats.setter(Builder::fullLoadFinishDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadFinishDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULL_LOAD_PROGRESS_PERCENT_FIELD, ELAPSED_TIME_MILLIS_FIELD, TABLES_LOADED_FIELD, TABLES_LOADING_FIELD, TABLES_QUEUED_FIELD, TABLES_ERRORED_FIELD, FRESH_START_DATE_FIELD, START_DATE_FIELD, STOP_DATE_FIELD, FULL_LOAD_START_DATE_FIELD, FULL_LOAD_FINISH_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FullLoadProgressPercent", FULL_LOAD_PROGRESS_PERCENT_FIELD);
            this.put("ElapsedTimeMillis", ELAPSED_TIME_MILLIS_FIELD);
            this.put("TablesLoaded", TABLES_LOADED_FIELD);
            this.put("TablesLoading", TABLES_LOADING_FIELD);
            this.put("TablesQueued", TABLES_QUEUED_FIELD);
            this.put("TablesErrored", TABLES_ERRORED_FIELD);
            this.put("FreshStartDate", FRESH_START_DATE_FIELD);
            this.put("StartDate", START_DATE_FIELD);
            this.put("StopDate", STOP_DATE_FIELD);
            this.put("FullLoadStartDate", FULL_LOAD_START_DATE_FIELD);
            this.put("FullLoadFinishDate", FULL_LOAD_FINISH_DATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer fullLoadProgressPercent;
    private final Long elapsedTimeMillis;
    private final Integer tablesLoaded;
    private final Integer tablesLoading;
    private final Integer tablesQueued;
    private final Integer tablesErrored;
    private final Instant freshStartDate;
    private final Instant startDate;
    private final Instant stopDate;
    private final Instant fullLoadStartDate;
    private final Instant fullLoadFinishDate;

    private ReplicationTaskStats(BuilderImpl builder) {
        this.fullLoadProgressPercent = builder.fullLoadProgressPercent;
        this.elapsedTimeMillis = builder.elapsedTimeMillis;
        this.tablesLoaded = builder.tablesLoaded;
        this.tablesLoading = builder.tablesLoading;
        this.tablesQueued = builder.tablesQueued;
        this.tablesErrored = builder.tablesErrored;
        this.freshStartDate = builder.freshStartDate;
        this.startDate = builder.startDate;
        this.stopDate = builder.stopDate;
        this.fullLoadStartDate = builder.fullLoadStartDate;
        this.fullLoadFinishDate = builder.fullLoadFinishDate;
    }

    public final Integer fullLoadProgressPercent() {
        return this.fullLoadProgressPercent;
    }

    public final Long elapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public final Integer tablesLoaded() {
        return this.tablesLoaded;
    }

    public final Integer tablesLoading() {
        return this.tablesLoading;
    }

    public final Integer tablesQueued() {
        return this.tablesQueued;
    }

    public final Integer tablesErrored() {
        return this.tablesErrored;
    }

    public final Instant freshStartDate() {
        return this.freshStartDate;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant stopDate() {
        return this.stopDate;
    }

    public final Instant fullLoadStartDate() {
        return this.fullLoadStartDate;
    }

    public final Instant fullLoadFinishDate() {
        return this.fullLoadFinishDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadProgressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesLoaded());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesLoading());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesQueued());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesErrored());
        hashCode = 31 * hashCode + Objects.hashCode(this.freshStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadFinishDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTaskStats)) {
            return false;
        }
        ReplicationTaskStats other = (ReplicationTaskStats)obj;
        return Objects.equals(this.fullLoadProgressPercent(), other.fullLoadProgressPercent()) && Objects.equals(this.elapsedTimeMillis(), other.elapsedTimeMillis()) && Objects.equals(this.tablesLoaded(), other.tablesLoaded()) && Objects.equals(this.tablesLoading(), other.tablesLoading()) && Objects.equals(this.tablesQueued(), other.tablesQueued()) && Objects.equals(this.tablesErrored(), other.tablesErrored()) && Objects.equals(this.freshStartDate(), other.freshStartDate()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.stopDate(), other.stopDate()) && Objects.equals(this.fullLoadStartDate(), other.fullLoadStartDate()) && Objects.equals(this.fullLoadFinishDate(), other.fullLoadFinishDate());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationTaskStats").add("FullLoadProgressPercent", (Object)this.fullLoadProgressPercent()).add("ElapsedTimeMillis", (Object)this.elapsedTimeMillis()).add("TablesLoaded", (Object)this.tablesLoaded()).add("TablesLoading", (Object)this.tablesLoading()).add("TablesQueued", (Object)this.tablesQueued()).add("TablesErrored", (Object)this.tablesErrored()).add("FreshStartDate", (Object)this.freshStartDate()).add("StartDate", (Object)this.startDate()).add("StopDate", (Object)this.stopDate()).add("FullLoadStartDate", (Object)this.fullLoadStartDate()).add("FullLoadFinishDate", (Object)this.fullLoadFinishDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FullLoadProgressPercent": {
                return Optional.ofNullable(clazz.cast(this.fullLoadProgressPercent()));
            }
            case "ElapsedTimeMillis": {
                return Optional.ofNullable(clazz.cast(this.elapsedTimeMillis()));
            }
            case "TablesLoaded": {
                return Optional.ofNullable(clazz.cast(this.tablesLoaded()));
            }
            case "TablesLoading": {
                return Optional.ofNullable(clazz.cast(this.tablesLoading()));
            }
            case "TablesQueued": {
                return Optional.ofNullable(clazz.cast(this.tablesQueued()));
            }
            case "TablesErrored": {
                return Optional.ofNullable(clazz.cast(this.tablesErrored()));
            }
            case "FreshStartDate": {
                return Optional.ofNullable(clazz.cast(this.freshStartDate()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "StopDate": {
                return Optional.ofNullable(clazz.cast(this.stopDate()));
            }
            case "FullLoadStartDate": {
                return Optional.ofNullable(clazz.cast(this.fullLoadStartDate()));
            }
            case "FullLoadFinishDate": {
                return Optional.ofNullable(clazz.cast(this.fullLoadFinishDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationTaskStats, T> g) {
        return obj -> g.apply((ReplicationTaskStats)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fullLoadProgressPercent;
        private Long elapsedTimeMillis;
        private Integer tablesLoaded;
        private Integer tablesLoading;
        private Integer tablesQueued;
        private Integer tablesErrored;
        private Instant freshStartDate;
        private Instant startDate;
        private Instant stopDate;
        private Instant fullLoadStartDate;
        private Instant fullLoadFinishDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTaskStats model) {
            this.fullLoadProgressPercent(model.fullLoadProgressPercent);
            this.elapsedTimeMillis(model.elapsedTimeMillis);
            this.tablesLoaded(model.tablesLoaded);
            this.tablesLoading(model.tablesLoading);
            this.tablesQueued(model.tablesQueued);
            this.tablesErrored(model.tablesErrored);
            this.freshStartDate(model.freshStartDate);
            this.startDate(model.startDate);
            this.stopDate(model.stopDate);
            this.fullLoadStartDate(model.fullLoadStartDate);
            this.fullLoadFinishDate(model.fullLoadFinishDate);
        }

        public final Integer getFullLoadProgressPercent() {
            return this.fullLoadProgressPercent;
        }

        public final void setFullLoadProgressPercent(Integer fullLoadProgressPercent) {
            this.fullLoadProgressPercent = fullLoadProgressPercent;
        }

        @Override
        public final Builder fullLoadProgressPercent(Integer fullLoadProgressPercent) {
            this.fullLoadProgressPercent = fullLoadProgressPercent;
            return this;
        }

        public final Long getElapsedTimeMillis() {
            return this.elapsedTimeMillis;
        }

        public final void setElapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
        }

        @Override
        public final Builder elapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
            return this;
        }

        public final Integer getTablesLoaded() {
            return this.tablesLoaded;
        }

        public final void setTablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
        }

        @Override
        public final Builder tablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
            return this;
        }

        public final Integer getTablesLoading() {
            return this.tablesLoading;
        }

        public final void setTablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
        }

        @Override
        public final Builder tablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
            return this;
        }

        public final Integer getTablesQueued() {
            return this.tablesQueued;
        }

        public final void setTablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
        }

        @Override
        public final Builder tablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
            return this;
        }

        public final Integer getTablesErrored() {
            return this.tablesErrored;
        }

        public final void setTablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
        }

        @Override
        public final Builder tablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
            return this;
        }

        public final Instant getFreshStartDate() {
            return this.freshStartDate;
        }

        public final void setFreshStartDate(Instant freshStartDate) {
            this.freshStartDate = freshStartDate;
        }

        @Override
        public final Builder freshStartDate(Instant freshStartDate) {
            this.freshStartDate = freshStartDate;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getStopDate() {
            return this.stopDate;
        }

        public final void setStopDate(Instant stopDate) {
            this.stopDate = stopDate;
        }

        @Override
        public final Builder stopDate(Instant stopDate) {
            this.stopDate = stopDate;
            return this;
        }

        public final Instant getFullLoadStartDate() {
            return this.fullLoadStartDate;
        }

        public final void setFullLoadStartDate(Instant fullLoadStartDate) {
            this.fullLoadStartDate = fullLoadStartDate;
        }

        @Override
        public final Builder fullLoadStartDate(Instant fullLoadStartDate) {
            this.fullLoadStartDate = fullLoadStartDate;
            return this;
        }

        public final Instant getFullLoadFinishDate() {
            return this.fullLoadFinishDate;
        }

        public final void setFullLoadFinishDate(Instant fullLoadFinishDate) {
            this.fullLoadFinishDate = fullLoadFinishDate;
        }

        @Override
        public final Builder fullLoadFinishDate(Instant fullLoadFinishDate) {
            this.fullLoadFinishDate = fullLoadFinishDate;
            return this;
        }

        public ReplicationTaskStats build() {
            return new ReplicationTaskStats(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationTaskStats> {
        public Builder fullLoadProgressPercent(Integer var1);

        public Builder elapsedTimeMillis(Long var1);

        public Builder tablesLoaded(Integer var1);

        public Builder tablesLoading(Integer var1);

        public Builder tablesQueued(Integer var1);

        public Builder tablesErrored(Integer var1);

        public Builder freshStartDate(Instant var1);

        public Builder startDate(Instant var1);

        public Builder stopDate(Instant var1);

        public Builder fullLoadStartDate(Instant var1);

        public Builder fullLoadFinishDate(Instant var1);
    }
}

