/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse;

public class DescribeRecommendationsIterable
implements SdkIterable<DescribeRecommendationsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRecommendationsIterable(DatabaseMigrationClient client, DescribeRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRecommendationsResponseFetcher();
    }

    public Iterator<DescribeRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeRecommendationsResponseFetcher
    implements SyncPageFetcher<DescribeRecommendationsResponse> {
        private DescribeRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRecommendationsResponse nextPage(DescribeRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRecommendationsIterable.this.client.describeRecommendations(DescribeRecommendationsIterable.this.firstRequest);
            }
            return DescribeRecommendationsIterable.this.client.describeRecommendations((DescribeRecommendationsRequest)((Object)DescribeRecommendationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

