/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionData> {
    private static final SdkField<String> PROVISION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionState").getter(ProvisionData.getter(ProvisionData::provisionState)).setter(ProvisionData.setter(Builder::provisionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionState").build()}).build();
    private static final SdkField<Integer> PROVISIONED_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProvisionedCapacityUnits").getter(ProvisionData.getter(ProvisionData::provisionedCapacityUnits)).setter(ProvisionData.setter(Builder::provisionedCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedCapacityUnits").build()}).build();
    private static final SdkField<Instant> DATE_PROVISIONED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateProvisioned").getter(ProvisionData.getter(ProvisionData::dateProvisioned)).setter(ProvisionData.setter(Builder::dateProvisioned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateProvisioned").build()}).build();
    private static final SdkField<Boolean> IS_NEW_PROVISIONING_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsNewProvisioningAvailable").getter(ProvisionData.getter(ProvisionData::isNewProvisioningAvailable)).setter(ProvisionData.setter(Builder::isNewProvisioningAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNewProvisioningAvailable").build()}).build();
    private static final SdkField<Instant> DATE_NEW_PROVISIONING_DATA_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateNewProvisioningDataAvailable").getter(ProvisionData.getter(ProvisionData::dateNewProvisioningDataAvailable)).setter(ProvisionData.setter(Builder::dateNewProvisioningDataAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateNewProvisioningDataAvailable").build()}).build();
    private static final SdkField<String> REASON_FOR_NEW_PROVISIONING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReasonForNewProvisioningData").getter(ProvisionData.getter(ProvisionData::reasonForNewProvisioningData)).setter(ProvisionData.setter(Builder::reasonForNewProvisioningData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonForNewProvisioningData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISION_STATE_FIELD, PROVISIONED_CAPACITY_UNITS_FIELD, DATE_PROVISIONED_FIELD, IS_NEW_PROVISIONING_AVAILABLE_FIELD, DATE_NEW_PROVISIONING_DATA_AVAILABLE_FIELD, REASON_FOR_NEW_PROVISIONING_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProvisionData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String provisionState;
    private final Integer provisionedCapacityUnits;
    private final Instant dateProvisioned;
    private final Boolean isNewProvisioningAvailable;
    private final Instant dateNewProvisioningDataAvailable;
    private final String reasonForNewProvisioningData;

    private ProvisionData(BuilderImpl builder) {
        this.provisionState = builder.provisionState;
        this.provisionedCapacityUnits = builder.provisionedCapacityUnits;
        this.dateProvisioned = builder.dateProvisioned;
        this.isNewProvisioningAvailable = builder.isNewProvisioningAvailable;
        this.dateNewProvisioningDataAvailable = builder.dateNewProvisioningDataAvailable;
        this.reasonForNewProvisioningData = builder.reasonForNewProvisioningData;
    }

    public final String provisionState() {
        return this.provisionState;
    }

    public final Integer provisionedCapacityUnits() {
        return this.provisionedCapacityUnits;
    }

    public final Instant dateProvisioned() {
        return this.dateProvisioned;
    }

    public final Boolean isNewProvisioningAvailable() {
        return this.isNewProvisioningAvailable;
    }

    public final Instant dateNewProvisioningDataAvailable() {
        return this.dateNewProvisioningDataAvailable;
    }

    public final String reasonForNewProvisioningData() {
        return this.reasonForNewProvisioningData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateProvisioned());
        hashCode = 31 * hashCode + Objects.hashCode(this.isNewProvisioningAvailable());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateNewProvisioningDataAvailable());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonForNewProvisioningData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionData)) {
            return false;
        }
        ProvisionData other = (ProvisionData)obj;
        return Objects.equals(this.provisionState(), other.provisionState()) && Objects.equals(this.provisionedCapacityUnits(), other.provisionedCapacityUnits()) && Objects.equals(this.dateProvisioned(), other.dateProvisioned()) && Objects.equals(this.isNewProvisioningAvailable(), other.isNewProvisioningAvailable()) && Objects.equals(this.dateNewProvisioningDataAvailable(), other.dateNewProvisioningDataAvailable()) && Objects.equals(this.reasonForNewProvisioningData(), other.reasonForNewProvisioningData());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionData").add("ProvisionState", (Object)this.provisionState()).add("ProvisionedCapacityUnits", (Object)this.provisionedCapacityUnits()).add("DateProvisioned", (Object)this.dateProvisioned()).add("IsNewProvisioningAvailable", (Object)this.isNewProvisioningAvailable()).add("DateNewProvisioningDataAvailable", (Object)this.dateNewProvisioningDataAvailable()).add("ReasonForNewProvisioningData", (Object)this.reasonForNewProvisioningData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionState": {
                return Optional.ofNullable(clazz.cast(this.provisionState()));
            }
            case "ProvisionedCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.provisionedCapacityUnits()));
            }
            case "DateProvisioned": {
                return Optional.ofNullable(clazz.cast(this.dateProvisioned()));
            }
            case "IsNewProvisioningAvailable": {
                return Optional.ofNullable(clazz.cast(this.isNewProvisioningAvailable()));
            }
            case "DateNewProvisioningDataAvailable": {
                return Optional.ofNullable(clazz.cast(this.dateNewProvisioningDataAvailable()));
            }
            case "ReasonForNewProvisioningData": {
                return Optional.ofNullable(clazz.cast(this.reasonForNewProvisioningData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProvisionState", PROVISION_STATE_FIELD);
        map.put("ProvisionedCapacityUnits", PROVISIONED_CAPACITY_UNITS_FIELD);
        map.put("DateProvisioned", DATE_PROVISIONED_FIELD);
        map.put("IsNewProvisioningAvailable", IS_NEW_PROVISIONING_AVAILABLE_FIELD);
        map.put("DateNewProvisioningDataAvailable", DATE_NEW_PROVISIONING_DATA_AVAILABLE_FIELD);
        map.put("ReasonForNewProvisioningData", REASON_FOR_NEW_PROVISIONING_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionData, T> g) {
        return obj -> g.apply((ProvisionData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String provisionState;
        private Integer provisionedCapacityUnits;
        private Instant dateProvisioned;
        private Boolean isNewProvisioningAvailable;
        private Instant dateNewProvisioningDataAvailable;
        private String reasonForNewProvisioningData;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionData model) {
            this.provisionState(model.provisionState);
            this.provisionedCapacityUnits(model.provisionedCapacityUnits);
            this.dateProvisioned(model.dateProvisioned);
            this.isNewProvisioningAvailable(model.isNewProvisioningAvailable);
            this.dateNewProvisioningDataAvailable(model.dateNewProvisioningDataAvailable);
            this.reasonForNewProvisioningData(model.reasonForNewProvisioningData);
        }

        public final String getProvisionState() {
            return this.provisionState;
        }

        public final void setProvisionState(String provisionState) {
            this.provisionState = provisionState;
        }

        @Override
        public final Builder provisionState(String provisionState) {
            this.provisionState = provisionState;
            return this;
        }

        public final Integer getProvisionedCapacityUnits() {
            return this.provisionedCapacityUnits;
        }

        public final void setProvisionedCapacityUnits(Integer provisionedCapacityUnits) {
            this.provisionedCapacityUnits = provisionedCapacityUnits;
        }

        @Override
        public final Builder provisionedCapacityUnits(Integer provisionedCapacityUnits) {
            this.provisionedCapacityUnits = provisionedCapacityUnits;
            return this;
        }

        public final Instant getDateProvisioned() {
            return this.dateProvisioned;
        }

        public final void setDateProvisioned(Instant dateProvisioned) {
            this.dateProvisioned = dateProvisioned;
        }

        @Override
        public final Builder dateProvisioned(Instant dateProvisioned) {
            this.dateProvisioned = dateProvisioned;
            return this;
        }

        public final Boolean getIsNewProvisioningAvailable() {
            return this.isNewProvisioningAvailable;
        }

        public final void setIsNewProvisioningAvailable(Boolean isNewProvisioningAvailable) {
            this.isNewProvisioningAvailable = isNewProvisioningAvailable;
        }

        @Override
        public final Builder isNewProvisioningAvailable(Boolean isNewProvisioningAvailable) {
            this.isNewProvisioningAvailable = isNewProvisioningAvailable;
            return this;
        }

        public final Instant getDateNewProvisioningDataAvailable() {
            return this.dateNewProvisioningDataAvailable;
        }

        public final void setDateNewProvisioningDataAvailable(Instant dateNewProvisioningDataAvailable) {
            this.dateNewProvisioningDataAvailable = dateNewProvisioningDataAvailable;
        }

        @Override
        public final Builder dateNewProvisioningDataAvailable(Instant dateNewProvisioningDataAvailable) {
            this.dateNewProvisioningDataAvailable = dateNewProvisioningDataAvailable;
            return this;
        }

        public final String getReasonForNewProvisioningData() {
            return this.reasonForNewProvisioningData;
        }

        public final void setReasonForNewProvisioningData(String reasonForNewProvisioningData) {
            this.reasonForNewProvisioningData = reasonForNewProvisioningData;
        }

        @Override
        public final Builder reasonForNewProvisioningData(String reasonForNewProvisioningData) {
            this.reasonForNewProvisioningData = reasonForNewProvisioningData;
            return this;
        }

        public ProvisionData build() {
            return new ProvisionData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionData> {
        public Builder provisionState(String var1);

        public Builder provisionedCapacityUnits(Integer var1);

        public Builder dateProvisioned(Instant var1);

        public Builder isNewProvisioningAvailable(Boolean var1);

        public Builder dateNewProvisioningDataAvailable(Instant var1);

        public Builder reasonForNewProvisioningData(String var1);
    }
}

