/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.DataBrewRequest;
import software.amazon.awssdk.services.databrew.model.DataCatalogOutput;
import software.amazon.awssdk.services.databrew.model.DataCatalogOutputListCopier;
import software.amazon.awssdk.services.databrew.model.DatabaseOutput;
import software.amazon.awssdk.services.databrew.model.DatabaseOutputListCopier;
import software.amazon.awssdk.services.databrew.model.EncryptionMode;
import software.amazon.awssdk.services.databrew.model.LogSubscription;
import software.amazon.awssdk.services.databrew.model.Output;
import software.amazon.awssdk.services.databrew.model.OutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRecipeJobRequest
extends DataBrewRequest
implements ToCopyableBuilder<Builder, UpdateRecipeJobRequest> {
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(UpdateRecipeJobRequest.getter(UpdateRecipeJobRequest::encryptionKeyArn)).setter(UpdateRecipeJobRequest.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionMode").getter(UpdateRecipeJobRequest.getter(UpdateRecipeJobRequest::encryptionModeAsString)).setter(UpdateRecipeJobRequest.setter(Builder::encryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateRecipeJobRequest.getter(UpdateRecipeJobRequest::name)).setter(UpdateRecipeJobRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> LOG_SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogSubscription").getter(UpdateRecipeJobRequest.getter(UpdateRecipeJobRequest::logSubscriptionAsString)).setter(UpdateRecipeJobRequest.setter(Builder::logSubscription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscription").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacity").getter(UpdateRecipeJobRequest.getter(UpdateRecipeJobRequest::maxCapacity)).setter(UpdateRecipeJobRequest.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRetries").getter(UpdateRecipeJobRequest.getter(UpdateRecipeJobRequest::maxRetries)).setter(UpdateRecipeJobRequest.setter(Builder::maxRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()}).build();
    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(UpdateRecipeJobRequest.getter(UpdateRecipeJobRequest::outputs)).setter(UpdateRecipeJobRequest.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataCatalogOutput>> DATA_CATALOG_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataCatalogOutputs").getter(UpdateRecipeJobRequest.getter(UpdateRecipeJobRequest::dataCatalogOutputs)).setter(UpdateRecipeJobRequest.setter(Builder::dataCatalogOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogOutputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataCatalogOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DatabaseOutput>> DATABASE_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatabaseOutputs").getter(UpdateRecipeJobRequest.getter(UpdateRecipeJobRequest::databaseOutputs)).setter(UpdateRecipeJobRequest.setter(Builder::databaseOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseOutputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatabaseOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateRecipeJobRequest.getter(UpdateRecipeJobRequest::roleArn)).setter(UpdateRecipeJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(UpdateRecipeJobRequest.getter(UpdateRecipeJobRequest::timeout)).setter(UpdateRecipeJobRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_KEY_ARN_FIELD, ENCRYPTION_MODE_FIELD, NAME_FIELD, LOG_SUBSCRIPTION_FIELD, MAX_CAPACITY_FIELD, MAX_RETRIES_FIELD, OUTPUTS_FIELD, DATA_CATALOG_OUTPUTS_FIELD, DATABASE_OUTPUTS_FIELD, ROLE_ARN_FIELD, TIMEOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
            this.put("EncryptionMode", ENCRYPTION_MODE_FIELD);
            this.put("name", NAME_FIELD);
            this.put("LogSubscription", LOG_SUBSCRIPTION_FIELD);
            this.put("MaxCapacity", MAX_CAPACITY_FIELD);
            this.put("MaxRetries", MAX_RETRIES_FIELD);
            this.put("Outputs", OUTPUTS_FIELD);
            this.put("DataCatalogOutputs", DATA_CATALOG_OUTPUTS_FIELD);
            this.put("DatabaseOutputs", DATABASE_OUTPUTS_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("Timeout", TIMEOUT_FIELD);
        }
    });
    private final String encryptionKeyArn;
    private final String encryptionMode;
    private final String name;
    private final String logSubscription;
    private final Integer maxCapacity;
    private final Integer maxRetries;
    private final List<Output> outputs;
    private final List<DataCatalogOutput> dataCatalogOutputs;
    private final List<DatabaseOutput> databaseOutputs;
    private final String roleArn;
    private final Integer timeout;

    private UpdateRecipeJobRequest(BuilderImpl builder) {
        super(builder);
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionMode = builder.encryptionMode;
        this.name = builder.name;
        this.logSubscription = builder.logSubscription;
        this.maxCapacity = builder.maxCapacity;
        this.maxRetries = builder.maxRetries;
        this.outputs = builder.outputs;
        this.dataCatalogOutputs = builder.dataCatalogOutputs;
        this.databaseOutputs = builder.databaseOutputs;
        this.roleArn = builder.roleArn;
        this.timeout = builder.timeout;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final EncryptionMode encryptionMode() {
        return EncryptionMode.fromValue(this.encryptionMode);
    }

    public final String encryptionModeAsString() {
        return this.encryptionMode;
    }

    public final String name() {
        return this.name;
    }

    public final LogSubscription logSubscription() {
        return LogSubscription.fromValue(this.logSubscription);
    }

    public final String logSubscriptionAsString() {
        return this.logSubscription;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final Integer maxRetries() {
        return this.maxRetries;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<Output> outputs() {
        return this.outputs;
    }

    public final boolean hasDataCatalogOutputs() {
        return this.dataCatalogOutputs != null && !(this.dataCatalogOutputs instanceof SdkAutoConstructList);
    }

    public final List<DataCatalogOutput> dataCatalogOutputs() {
        return this.dataCatalogOutputs;
    }

    public final boolean hasDatabaseOutputs() {
        return this.databaseOutputs != null && !(this.databaseOutputs instanceof SdkAutoConstructList);
    }

    public final List<DatabaseOutput> databaseOutputs() {
        return this.databaseOutputs;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.logSubscriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataCatalogOutputs() ? this.dataCatalogOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabaseOutputs() ? this.databaseOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecipeJobRequest)) {
            return false;
        }
        UpdateRecipeJobRequest other = (UpdateRecipeJobRequest)((Object)obj);
        return Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.encryptionModeAsString(), other.encryptionModeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.logSubscriptionAsString(), other.logSubscriptionAsString()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.maxRetries(), other.maxRetries()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && this.hasDataCatalogOutputs() == other.hasDataCatalogOutputs() && Objects.equals(this.dataCatalogOutputs(), other.dataCatalogOutputs()) && this.hasDatabaseOutputs() == other.hasDatabaseOutputs() && Objects.equals(this.databaseOutputs(), other.databaseOutputs()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.timeout(), other.timeout());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRecipeJobRequest").add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("EncryptionMode", (Object)this.encryptionModeAsString()).add("Name", (Object)this.name()).add("LogSubscription", (Object)this.logSubscriptionAsString()).add("MaxCapacity", (Object)this.maxCapacity()).add("MaxRetries", (Object)this.maxRetries()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("DataCatalogOutputs", this.hasDataCatalogOutputs() ? this.dataCatalogOutputs() : null).add("DatabaseOutputs", this.hasDatabaseOutputs() ? this.databaseOutputs() : null).add("RoleArn", (Object)this.roleArn()).add("Timeout", (Object)this.timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "EncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.encryptionModeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "LogSubscription": {
                return Optional.ofNullable(clazz.cast(this.logSubscriptionAsString()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "MaxRetries": {
                return Optional.ofNullable(clazz.cast(this.maxRetries()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "DataCatalogOutputs": {
                return Optional.ofNullable(clazz.cast(this.dataCatalogOutputs()));
            }
            case "DatabaseOutputs": {
                return Optional.ofNullable(clazz.cast(this.databaseOutputs()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecipeJobRequest, T> g) {
        return obj -> g.apply((UpdateRecipeJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewRequest.BuilderImpl
    implements Builder {
        private String encryptionKeyArn;
        private String encryptionMode;
        private String name;
        private String logSubscription;
        private Integer maxCapacity;
        private Integer maxRetries;
        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();
        private List<DataCatalogOutput> dataCatalogOutputs = DefaultSdkAutoConstructList.getInstance();
        private List<DatabaseOutput> databaseOutputs = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private Integer timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecipeJobRequest model) {
            super(model);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.encryptionMode(model.encryptionMode);
            this.name(model.name);
            this.logSubscription(model.logSubscription);
            this.maxCapacity(model.maxCapacity);
            this.maxRetries(model.maxRetries);
            this.outputs(model.outputs);
            this.dataCatalogOutputs(model.dataCatalogOutputs);
            this.databaseOutputs(model.databaseOutputs);
            this.roleArn(model.roleArn);
            this.timeout(model.timeout);
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getEncryptionMode() {
            return this.encryptionMode;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionMode encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLogSubscription() {
            return this.logSubscription;
        }

        public final void setLogSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
        }

        @Override
        public final Builder logSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        @Override
        public final Builder logSubscription(LogSubscription logSubscription) {
            this.logSubscription(logSubscription == null ? null : logSubscription.toString());
            return this;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getMaxRetries() {
            return this.maxRetries;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = OutputListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (Output)((Output.Builder)Output.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataCatalogOutput.Builder> getDataCatalogOutputs() {
            List<DataCatalogOutput.Builder> result = DataCatalogOutputListCopier.copyToBuilder(this.dataCatalogOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataCatalogOutputs(Collection<DataCatalogOutput.BuilderImpl> dataCatalogOutputs) {
            this.dataCatalogOutputs = DataCatalogOutputListCopier.copyFromBuilder(dataCatalogOutputs);
        }

        @Override
        public final Builder dataCatalogOutputs(Collection<DataCatalogOutput> dataCatalogOutputs) {
            this.dataCatalogOutputs = DataCatalogOutputListCopier.copy(dataCatalogOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCatalogOutputs(DataCatalogOutput ... dataCatalogOutputs) {
            this.dataCatalogOutputs(Arrays.asList(dataCatalogOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCatalogOutputs(Consumer<DataCatalogOutput.Builder> ... dataCatalogOutputs) {
            this.dataCatalogOutputs(Stream.of(dataCatalogOutputs).map(c -> (DataCatalogOutput)((DataCatalogOutput.Builder)DataCatalogOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DatabaseOutput.Builder> getDatabaseOutputs() {
            List<DatabaseOutput.Builder> result = DatabaseOutputListCopier.copyToBuilder(this.databaseOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabaseOutputs(Collection<DatabaseOutput.BuilderImpl> databaseOutputs) {
            this.databaseOutputs = DatabaseOutputListCopier.copyFromBuilder(databaseOutputs);
        }

        @Override
        public final Builder databaseOutputs(Collection<DatabaseOutput> databaseOutputs) {
            this.databaseOutputs = DatabaseOutputListCopier.copy(databaseOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseOutputs(DatabaseOutput ... databaseOutputs) {
            this.databaseOutputs(Arrays.asList(databaseOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseOutputs(Consumer<DatabaseOutput.Builder> ... databaseOutputs) {
            this.databaseOutputs(Stream.of(databaseOutputs).map(c -> (DatabaseOutput)((DatabaseOutput.Builder)DatabaseOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecipeJobRequest build() {
            return new UpdateRecipeJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataBrewRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRecipeJobRequest> {
        public Builder encryptionKeyArn(String var1);

        public Builder encryptionMode(String var1);

        public Builder encryptionMode(EncryptionMode var1);

        public Builder name(String var1);

        public Builder logSubscription(String var1);

        public Builder logSubscription(LogSubscription var1);

        public Builder maxCapacity(Integer var1);

        public Builder maxRetries(Integer var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder outputs(Consumer<Output.Builder> ... var1);

        public Builder dataCatalogOutputs(Collection<DataCatalogOutput> var1);

        public Builder dataCatalogOutputs(DataCatalogOutput ... var1);

        public Builder dataCatalogOutputs(Consumer<DataCatalogOutput.Builder> ... var1);

        public Builder databaseOutputs(Collection<DatabaseOutput> var1);

        public Builder databaseOutputs(DatabaseOutput ... var1);

        public Builder databaseOutputs(Consumer<DatabaseOutput.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder timeout(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

